// Sound Prim Script - Intermittent Daytime v0.1 by Anonymous (2010)
// Modified by djphil (2020) to start automaticly

float LOUDNESS = 1.0;
integer SHORTEST = 10;
integer LONGEST = 25;

default
{
    state_entry()
    {
        if (SHORTEST < 10 ) SHORTEST = 10;
        if (LONGEST < 10 ) LONGEST = 10;
        if (SHORTEST > LONGEST) SHORTEST = LONGEST;
        llSleep(1.0);   
        state noisy;
    }

    on_rez(integer param)
    {
        llResetScript();
    }

    changed(integer change)
    {
        if (change & CHANGED_REGION_START)
        {
            llResetScript();
        }
    }
}

state noisy
{
    state_entry()
    {
        vector sun_point = llGetSunDirection();
        if ( sun_point.z < 0.0 ) state silent;
       
        integer sounds = llGetInventoryNumber(INVENTORY_SOUND);
        if ( sounds <= 0 ) state default;
   
        string soundname = llGetInventoryName( INVENTORY_SOUND, llFloor(llFrand(sounds)) );
        if ( soundname != "" )
        {
            llPlaySound( soundname, LOUDNESS );
        }
       
        state silent;
    }
   
    on_rez(integer param)
    {
        llResetScript();
    }

    changed(integer change)
    {
        if (change & CHANGED_REGION_START)
        {
            llResetScript();
        }
    }
}

state silent
{
    state_entry()
    {   
        llSleep( (float)(llFloor(llFrand(LONGEST - SHORTEST)) + SHORTEST) );
        state noisy;
    }
   
    on_rez(integer param)
    {
        llResetScript();
    }

    changed(integer change)
    {
        if (change & CHANGED_REGION_START)
        {
            llResetScript();
        }
    }
} 