string card="bookmarks.webgl";
integer i=0;
integer pointer=0;
list URLs;
list Hover;
key owner;
integer listenID;
key gLineRequestID; // expected dataserver event
integer gLineCounter;   // The number of lines in the NC, as determined by this script

list StrideOfList(list src, integer stride, integer start, integer end)
{
    list l = [];
    integer ll = llGetListLength(src);
    if(start < 0)start += ll;
    if(end < 0)end += ll;
    if(end < start) return llList2List(src, start, start);
    while(start <= end)
    {
        l += llList2List(src, start, start);
        start += stride;
    }
    return l;
}

default
{
    state_entry()
    {
        llSetText("Loading bookmarks", <1,1,1>, 1.0);
        llGetNotecardLine(card, i);
        owner=llGetOwner();
    }

    touch_start(integer times)
    {
        key who=llDetectedKey(0);
        if(who==owner)
        {
            llDialog(owner, "Open URL or select new target?", ["<", ">","List","Open","Reload", "Last"], 1001);
            llListenRemove(listenID);
            listenID=llListen(1001, "", owner, "");
        }

        else
        {
            llLoadURL(llDetectedKey(0), "Load "+llList2String(Hover, pointer), llList2String(URLs, pointer));
        }
    }

    dataserver(key query, string data)
    {
        if(data!=EOF)
        {
            list temp=llCSV2List(data);
            Hover+=llList2String(temp, 0);
            URLs+=llList2String(temp, 1);
            i++;
            llGetNotecardLine(card, i);
        }
        else
        {
            llSetText(llList2String(Hover, pointer), <1,1,1>, 1.0);
        }
        
        if (query == gLineRequestID)
        {
                 llOwnerSay( data );
                 gLineCounter = (integer) data;
        }
        
    }

    listen(integer channel, string name, key ID, string message)
    {
        llSetTimerEvent(60);
        
        if(message=="List")
        { 
       gLineRequestID = llGetNumberOfNotecardLines(card);     
       llSay(0, "number of lines: " +(string)gLineCounter);
       
       integer counter = 0;
       integer futz = 1;
         while(counter < (gLineCounter-1))
         {
           llSay(0, (string)futz +": " +llList2String(Hover, counter));
           counter++;
           futz++;
         }
           
       }
       if (message=="Reload")
       {
                       llResetScript();
       }
       else if (message=="Last")
       {
           //pointer=gLineCounter;
           pointer=llGetListLength(Hover);           
           llSetText(llList2String(Hover, pointer), <1,1,1>, 1.0);

       }
   
        if(message=="Open")
        {
            llLoadURL(llGetOwner(), "Load "+llList2String(URLs, pointer), llList2String(Hover, pointer));

        }

        else if(message=="<")
        {
            pointer++;
            if(pointer==llGetListLength(Hover))
            {
                pointer=0;
            }
            llSay(0, "PrevPointer: " +(string)pointer);
        }

    
        else if(message==">")
        {
            pointer--;
            if(pointer<0)
            {
                pointer=llGetListLength(Hover);
                pointer--;
                llSay(0, "NextPointer: " +(string)pointer);
            }
        }
        llSetText(llList2String(Hover, pointer), <1,1,1>, 1.0);
        llListenRemove(listenID);
    }

    changed(integer change)
    {
        if(change & CHANGED_INVENTORY)
        {
            llResetScript();
        }
    }

    timer()
    {
        llListenRemove(listenID);   
    }
}