key sitting;

default
{
    state_entry()
    {
        sitting = NULL_KEY;
        llSitTarget(<0,0,-3>,ZERO_ROTATION);
    }

    changed(integer what)
    {
        key av = llAvatarOnSitTarget();
        if (av != NULL_KEY) {
            vector original_pos = llGetPos();
            vector new_pos = original_pos;
            new_pos.z = 760.0;
            float dist = new_pos.z - original_pos.z;
            integer steps = (integer)llCeil(dist / 9.9);
            float stepdist = dist / steps;
            integer i = 1;
            list lxUpParams = [PRIM_POSITION, new_pos];
            list lxDownParams = [PRIM_POSITION, original_pos];
            while (i*2 < steps) {
                i = i*2;
                lxUpParams = lxUpParams + lxUpParams;
                lxDownParams = lxDownParams + lxDownParams;
            }
            while (i < steps) {
                i += 1;
                lxUpParams = lxUpParams + [PRIM_POSITION, new_pos];
                lxDownParams = lxDownParams + [PRIM_POSITION, original_pos];
            }
            llSetPrimitiveParams(lxUpParams);
            llSleep(1.0);
            llSetPrimitiveParams(lxDownParams);
            llUnSit(av);
        }
    }
}
