/*************************************************
[XEngine]
    ...
    Allow_osMakeNotecard = "PARCEL_OWNER, ESTATE_OWNER"
    Allow_osGetNotecard = "PARCEL_OWNER, ESTATE_OWNER"
*************************************************/

list VisitorsNames;
list VisitorHG;
list UsersSourceGrid;
list BannedUsers;

integer DISPLAY_SIDE = 3;
integer COLUMNS = 2;
integer ROWS = 16;

integer NCLine;

DrawTexture()
{
    integer TEXTURE_SIZE = 1024;
    integer FONT_SIZE = (TEXTURE_SIZE / ROWS) / 2;

    string drawList;
    drawList = osSetPenSize(drawList, 1);
    drawList = osSetFontSize(drawList, FONT_SIZE);

    drawList = osMovePen(drawList, 0, 0);
    drawList = osSetPenColor(drawList, "Gray");
    drawList = osDrawFilledRectangle(drawList, TEXTURE_SIZE, TEXTURE_SIZE);

    integer x;
    integer y;
    for (x = 0; x < COLUMNS; x++)
    {
        for (y = 0; y < ROWS; y++)
        {
            integer CELL_HEIGHT = TEXTURE_SIZE / ROWS;
            integer CELL_WIDHT = TEXTURE_SIZE / COLUMNS;
            integer xTopLeft = x * CELL_WIDHT;
            integer yTopLeft = y * CELL_HEIGHT;

            drawList = osSetPenColor(drawList, "White");
            drawList = osMovePen(drawList, xTopLeft, yTopLeft);
            drawList = osDrawRectangle(drawList, CELL_WIDHT, CELL_HEIGHT);

            integer index = (y + x * ROWS);
            string  cellName  = llList2String(VisitorsNames, index);
            integer cellValid = TRUE;

            if (llList2Integer(VisitorHG, index) == TRUE)
             {cellValid = FALSE;}

            string cellBbackground;
            string Globe = "";
            if (cellName == "")
             {cellBbackground = "Black";}
            else
            {
                if (cellValid)
                 {cellBbackground = "Red";}
                else
                {
                    cellBbackground = "LightBlue";
                    Globe = "hg.on.png";
                }
            }

            drawList = osSetPenColor(drawList, cellBbackground);
            drawList = osMovePen(drawList, xTopLeft + 2, yTopLeft + 2);
            drawList = osDrawFilledRectangle(drawList, CELL_WIDHT - 3, CELL_HEIGHT - 3);

            xTopLeft += 2;
            yTopLeft += 6;
            drawList = osSetPenColor(drawList, "Yellow");
            drawList = osMovePen(drawList, xTopLeft, yTopLeft - 1);
            if (Globe != "")
            {
                drawList = osMovePen(drawList, xTopLeft + 3, yTopLeft + 3);
                drawList = osDrawImage(drawList, 16, 16, "http://opensimwiki.de/" + Globe);
                drawList = osMovePen(drawList, xTopLeft + 20, yTopLeft - 1);
            }
            
            list TempName = llParseString2List(cellName, [" "], []);
            if (llToLower(llList2String(TempName, 1)) == "resident")
             {cellName = llList2String(TempName, 0);}
            
            drawList = osDrawText(drawList, cellName);
        }
    }
    osSetDynamicTextureDataBlendFace("", "vector", drawList, "alpha:false,width:" + (string)TEXTURE_SIZE + ",height:" + (string)TEXTURE_SIZE, FALSE, 2, 0, 255, DISPLAY_SIDE);
}

SaveMemoryToNC()
{
    list Temp;
    integer i;
    for (i = 0; i < llGetListLength(VisitorsNames); ++i)
    {
        string HG = "0";
        if (llList2Integer(VisitorHG, i) == TRUE)
         {HG = "1";}
        Temp = Temp + [llList2String(VisitorsNames, i) + "|" + HG + "|" + llList2String(UsersSourceGrid, i)];
    }
    if (llGetInventoryType(".Visitors.Memory") == INVENTORY_NOTECARD)
     {llRemoveInventory(".Visitors.Memory");}
    osMakeNotecard(".Visitors.Memory", Temp);
}

integer isUserBanned(string Name)
{
    integer i;
    for (i = 0; i < llGetListLength(BannedUsers); ++i)
    {
        if (llToLower(Name) == llToLower(llList2String(BannedUsers, i)))
         {return TRUE;}
    }
    return FALSE;
}

key GetAvatarKeyByName(string Name)
{
    list Avas = osGetAvatarList();
    integer i;
    for (i = 0; i < llGetListLength(Avas); i = i + 3)
    {
        if (llToLower(Name) == llToLower(llList2String(Avas, i + 2)))
         {return llList2Key(Avas, i);}
    }
    return NULL_KEY;
}


default
{
    on_rez(integer Dummy)
     {llResetScript();}
    changed(integer What)
    {
        if (What & CHANGED_REGION_START)
         {llResetScript();}
    }
    state_entry()
    {
        if (llGetInventoryType(".Visitors.Memory") == INVENTORY_NOTECARD)
        {
            llSetText("Lade Speicher...", <1, 1, 0>, 1);
            string Temp = osGetNotecard(".Visitors.Memory");
            list Tmp = llParseString2List(Temp, ["\n"], []);
            integer i;
            for (i = 0; i < llGetListLength(Tmp); ++i)
            {
                list Tmp2 = llParseString2List(llList2String(Tmp, i), ["|"], []);
                VisitorsNames = VisitorsNames + [llList2String(Tmp2, 0)];
                VisitorHG = VisitorHG + [llList2Integer(Tmp2, 1)];
                UsersSourceGrid = UsersSourceGrid  + [llList2String(Tmp2, 2)];
            }
        }
        
        llSetText("Lade Banliste...", <1, 1, 0>, 1);
        NCLine = 0;
        BannedUsers = [];
        llGetNotecardLine("Banned", NCLine);
    }
    dataserver(key ID, string Data)
    {
        if (Data == EOF)
         {state Running;}
        if (Data != "")
         {BannedUsers = BannedUsers + [Data];}
        NCLine = NCLine + 1;
        llGetNotecardLine("Banned", NCLine);
    }
}

state Running
{
    on_rez(integer Dummy)
     {llResetScript();}
    state_entry()
    {
        llSetText("", <0, 0, 0>, 0);
        llSetTimerEvent(2);
    }
    timer()
    {
        integer WasChange = FALSE;
        list Agents = osGetAgents();
        integer i;
        for (i = 0; i < llGetListLength(Agents); ++i)
        {
            string Name = llList2String(Agents, i);
            string HGSource = "hier";
            list HGCheck = llParseString2List(Name, ["@"], []);
            integer IsHG = FALSE;
            if (llGetListLength(HGCheck) == 2)
            {
                HGSource = llList2String(HGCheck, 1);
                HGCheck = llParseString2List(llList2String(HGCheck, 0), ["."], []);
                Name = llStringTrim(llDumpList2String(HGCheck, " "), STRING_TRIM);
                IsHG = TRUE;
            }
            if (isUserBanned(Name))
            {
                key KickAgent = GetAvatarKeyByName(Name);
                if (KickAgent != NULL_KEY)
                {
                    llTeleportAgentHome(KickAgent);
                }
            }
            else
            {
                if (llListFindList(VisitorsNames, [Name]) == -1)
                {
                    VisitorsNames = [Name] + VisitorsNames;
                    VisitorHG = [IsHG] + VisitorHG;
                    UsersSourceGrid = [HGSource] + UsersSourceGrid;
                    WasChange = TRUE;
                }
                while (llGetListLength(VisitorsNames) > COLUMNS * ROWS)
                {
                    VisitorsNames = llList2List(VisitorsNames, 0, llGetListLength(VisitorsNames) - 2);
                    VisitorHG = llList2List(VisitorHG, 0, llGetListLength(VisitorHG) - 2);
                    UsersSourceGrid = llList2List(UsersSourceGrid, 0, llGetListLength(UsersSourceGrid) - 2);
                }
            }
        }
        if (WasChange)
        {
            DrawTexture();
            SaveMemoryToNC();
        }
    }
    changed(integer What)
    {
        if (What & CHANGED_REGION_START)
         {llResetScript();}
    }
    touch_start(integer Dummy)
    {
        vector point = llDetectedTouchST(0);
        integer face = llDetectedTouchFace(0);
        integer link = llDetectedLinkNumber(0);

        if (link != LINK_ROOT)
         {return;}

        if (point == TOUCH_INVALID_TEXCOORD)
         {return;}
         
        if (face != DISPLAY_SIDE)
         {return;}

        integer y = (ROWS - 1) - llFloor(point.y * ROWS);
        integer x = llFloor(point.x * COLUMNS);
        integer index = (y + x * ROWS);
        
        llInstantMessage(llDetectedKey(0), "User " + llList2String(VisitorsNames, index) + " kommt von " + llList2String(UsersSourceGrid, index) + ".");
    }
} 