// fly 6.1_OSG by Us Vemo 2011 june 20
// ===========================================
// Declarations
// User settable parameters:
// settings for bay in the middle

float activity=11.0;
float dist=0.5;
integer debug=0; //1= meddelanden, 0 = tyst
integer speed=10;
float fspeed;
float sleep=3;
integer sleep_distance=96;

string anim_name="tail";
float sleep_time=8.0;
float time=0.2 ;                // time between frames

integer x_angle= 90; // fixed
integer y_angle= 270; // change for swim direction 0=W 90=S 180=E 270=N
integer z_angle= 0; //    fixed
integer nr=0;
integer run=1;
integer vinkel=0;

integer loaded = FALSE; //check for config file
integer index;
string notecardName="Config"; //Default name=Config
key notecardQuery;
integer notecardIndex;


float x_min=0.0;
float y_min=0.0;
float z_min=0.0;
float x_max=0.0;
float y_max=0.0;
float z_max=0.0;

float x_mid=0.0;
float y_mid=0.0;
float z_mid=0.0;
float x_dif=0.0;
float y_dif=0.0;
float z_dif=0.0;

float x_nest=0.0;
float y_nest=0.0;
float z_nest=0.0;


// Variables
integer varv=0;
float x=0;
float y=0;
float z=0;

float xpos=0;
float ypos=0;
float zpos=0;

string item1;
string item2;
string item3;
string item4;
string item5;
string item6;
string item7;
string item8;
string item9;
string item10;
string item11;
string item12;
string item13;
string item14;

integer LWD=5;
integer LWU=6;
// integer LWR=3;
integer RWD=7;
integer RWU=8;
// integer RWR=2;



// Main
// ======
default
{
    on_rez(integer start_param)
    {
        llResetScript();
    }


    state_entry()
    {
        if( loaded == FALSE )
        {
            llSay(0,"start");
            state loading;
        }
        else
        {
            // ------ Convert to right variables
            list my_list=[item1,item2,item3,item4,item5,item6,item7,item8,item9,item10,item11,item12,item13,item14];
            x_mid=llList2Float(my_list,0);
            y_mid=llList2Float(my_list,1);
            z_mid=llList2Float(my_list,2);
            x_dif=llList2Float(my_list,3);
            y_dif=llList2Float(my_list,4);
            z_dif=llList2Float(my_list,5);
            activity=llList2Float(my_list,6);
            fspeed=llList2Float(my_list,7);
            speed=(integer)fspeed;
            llSay(0,"Speed="+(string)speed);
            sleep_time=llList2Float(my_list,8);
            anim_name=llList2String(my_list,9);
            sleep_distance=llList2Integer(my_list,10);
            x_nest=llList2Float(my_list,11);
            y_nest=llList2Float(my_list,12);
            z_nest=llList2Float(my_list,13);

            x_min=x_mid - x_dif;
            x_max=x_mid + x_dif;
            y_min=y_mid - y_dif;
            y_max=y_mid + y_dif;
            z_min=z_mid - z_dif;
            z_max=z_mid + z_dif;
            if( debug == 1)
            {
                llSay(0,"x_min="+(string)x_min);
                llSay(0,"x_max="+(string)x_max);
                llSay(0,"y_min="+(string)y_min);
                llSay(0,"y_max="+(string)y_max);
                llSay(0,"z_min="+(string)z_min);
                llSay(0,"z_max="+(string)z_max);
                llSay(0,"Activity="+(string)activity);
                llSay(0,"Swim speed="+(string)speed);
                llSay(0,"Sleep time="+(string)sleep_time);
                llSay(0,"Animation name="+anim_name);
                llSay(0,"Sleep distance="+(string)sleep_distance);
                llSay(0,"x_nest="+(string)x_nest);
                llSay(0,"x_nest="+(string)x_nest);
                llSay(0,"y_nest="+(string)y_nest);
            }
            state run;
        }
    }
}

state start
{
    state_entry()
    {
        llSetTimerEvent(0);
        llSay(0,"Click on the animal to start the movement!");
    }
    touch_start(integer total_number)
    {
        state run;
    }
}

state run
{
    state_entry()
    {
        llSetTimerEvent(sleep_time);
        llSay(0,"Moving!");
    }
    touch_start(integer total_number)
    {
        state start;
    }


    timer()
    {

//        llSetLinkAlpha(RWR,0.0, ALL_SIDES);
//        llSetLinkAlpha(LWR,0.0, ALL_SIDES);
//        llSetLinkAlpha(RWD,1.0, ALL_SIDES);
//        llSetLinkAlpha(LWD,1.0, ALL_SIDES);
//        llSetTimerEvent(sleep_time);
        integer random = 1+(integer)llFrand(20);//will return an integer 0 to activity
//        llSay(0,(string)random);
        vinkel=0;
        if (random <=6)
        {
            z_angle =0;
            vinkel =1;

            if (random == 1) y_angle = y_angle + 90;
            else if (random == 2) z_angle = z_angle + 15;
            else if (random == 3)
            {
                y_angle = y_angle + 45;
                z_angle = z_angle + 15;
            }
            else if (random ==4) z_angle = z_angle - 15;
            else if (random == 5) y_angle = y_angle -90;
            else if (random == 6) y_angle = y_angle -45;


            if (y_angle >= 360) y_angle=y_angle-360;
            else if (y_angle < 0) y_angle=y_angle+360;
        }
        if (random >= 8 && random <=15)
        {

            llSetLinkAlpha(LWD,0.0, ALL_SIDES);
            llSetLinkAlpha(RWD,0.0, ALL_SIDES);
            llSetLinkAlpha(LWU,1.0, ALL_SIDES);
            llSetLinkAlpha(RWU,1.0, ALL_SIDES);
            llSleep(2.0);

            llSetLinkAlpha(LWU,0.0, ALL_SIDES);
            llSetLinkAlpha(RWU,0.0, ALL_SIDES);
            llSetLinkAlpha(LWD,1.0, ALL_SIDES);
            llSetLinkAlpha(RWD,1.0, ALL_SIDES);

        }

        vector pos = llGetPos();

        xpos=pos.x;
        ypos=pos.y;
        zpos=pos.z;

        // check if the edge of the sim is close then change direction
        if (xpos <= x_min)
        {
            y_angle = 180;
            vinkel =1;
        }
        else if (xpos >= x_max)
        {
            y_angle = 0;
            vinkel =1;
        }
        else if (ypos <= y_min)
        {
            y_angle = 270;
            vinkel =1;
        }
        else if (ypos >= y_max)
        {
            y_angle = 90;
            vinkel =1;
        }
        if (zpos >= z_max)
        {
            z_angle = 15;
            vinkel =1;
        }
        else if (zpos <= z_min)
        {
            z_angle = -15;
            vinkel =1;
        }
        if (vinkel == 1)
        {
            vector eul = <x_angle,y_angle,z_angle>; // angle degrees around the z-axis, in Euler form
            eul *= DEG_TO_RAD; //convert to radians
            rotation quat = llEuler2Rot(eul); //convert to quaternion
            llSetRot(quat); //rotate the object
            vinkel = 0;
        }
        x=0.0;
        y=0.0;
        z=0.0;

        // move depending on facing angle

        if (y_angle == 0) x = -dist;
        else if (y_angle == 90) y = -dist;
        else if (y_angle == 180) x = dist;
        else if (y_angle == 270) y = dist;
        else if (y_angle == 45)
        {
            y = -dist;
            x = -dist;
        }
        else if (y_angle == 135)
        {
            y = -dist;
            x = dist;
        }
        else if (y_angle == 225)
        {
            y = dist;
            x = dist;
        }
        else if (y_angle == 270)
        {
            y = -dist;
            x = dist;
        }

        if (z_angle > 0) z= -dist;
        else if (z_angle < 0) z= dist;
            speed=20;
        for (varv=0; varv <= speed; varv=varv+1)
        {
            llSetPos(llGetPos()+<x,y,z>);
        }
    }
}


state loading
{
    state_entry()
    {
        llSay(0,"Loading configuration data...");
        notecardIndex = 0;
        notecardQuery = llGetNotecardLine(notecardName,notecardIndex++);
    }

    dataserver(key query_id, string data)
    {
        if ( notecardQuery == query_id)
        {
            // this is a line of our notecard
            if (data == EOF)
            {
                llSay(0,"Config loaded...");
                loaded = TRUE;
                state default;

            }
            else
            {
                if (notecardIndex == 1) item1 = data;
                if (notecardIndex == 2) item2 = data;
                if (notecardIndex == 3) item3 = data;
                if (notecardIndex == 4) item4 = data;
                if (notecardIndex == 5) item5 = data;
                if (notecardIndex == 6) item6 = data;
                if (notecardIndex == 7) item7 = data;
                if (notecardIndex == 8) item8 = data;
                if (notecardIndex == 9) item9 = data;
                if (notecardIndex == 10) item10 = data;
                if (notecardIndex == 11) item11 = data;
                if (notecardIndex == 12) item12 = data;
                if (notecardIndex == 13) item13 = data;
                if (notecardIndex == 14) item14 = data;
                notecardQuery = llGetNotecardLine(notecardName,notecardIndex++);
            }
        }
    }
}



