////////////////////////////////////
//
//
// number puzzle linked panel
//
// by wam7c macchi
//
/////////////////////////////////////


// this cube listens on this channel:
integer cubeCHANNEL=1015;
integer transcubeCHANNEL=1000;

// number of textures and sounds in the prim
integer numbertextures = 0;
integer numbersounds = 0;

// current texture and sound pointed to in the list
integer textureselected = 1;
integer soundselected = 1;

// set to llListen(cubeCHANNEL,"",NULL_KEY,""); in init()
integer storelisten = 0;

//
//
// UPDATE TEXT FUNCTION DEFINITION
// 
// Plays sounds and sets textures
// llGetInventoryName
// string llGetInventoryName(integer type, index)
// Gets the name of the inventory item of the number of stated type.
//
playsetnew()
{

    llPlaySound(llGetInventoryName(INVENTORY_SOUND,(soundselected - 1)),1);

    llSetTexture(llGetInventoryName(INVENTORY_TEXTURE,(textureselected - 1)),ALL_SIDES);

}
//
// INIT FUNCTION DEFINITION
// Init() resets the listen handle and updates floating text
// also sets numbertextures and sounds
//
Init()
{

    numbertextures = llGetInventoryNumber(INVENTORY_TEXTURE);
    numbersounds = llGetInventoryNumber(INVENTORY_SOUND);

    textureselected = 6;
    soundselected = 6;

    playsetnew();
    llListenRemove(storelisten);
    storelisten = llListen(cubeCHANNEL,"",NULL_KEY,"");


}

//
// SWITCHPIC FUNCTION DEFINITION
//
// increments integer textureselected. textureselected will be
// a pointer to llGetInventoryName.
// tests to see if textureselected greater than numbertextures (of textures)
// subtracts numbertextures from textureselected, returning it to 1 (or zero?)

switchpic()
{
    textureselected++;
    soundselected++;
    if (textureselected > numbertextures || soundselected > numbersounds)
        textureselected = textureselected - numbertextures;
    soundselected = textureselected;
    playsetnew();

}

///////////////////////////////////////////////////////
//
//
// ENTER DEFAULT
//
//
////////////////////////////////////////////////////////
default
{
    state_entry()
    {

        Init();

    }

    /////////////////////////////////////////////////////////
    //
    //
    // LISTEN EVENT HANDLER
    //
    //
    /////////////////////////////////////////////////////////
    listen(integer channel, string name, key id, string msg)
    {

        // notice (command, 0) is the first string typed and (command, 1) the second
        list command = llParseString2List(msg,[""],[]);

        if(llList2String(command,0)=="reset")
        {
        Init();
        }

       else if(llList2String(command,0)!="reset")
       {
//////////////////////////////////////


       vector newposition = (vector)msg;
        string position1 = (string)llGetLocalPos();
       
       llSleep(1);
       llSay(1000, (string)position1);
        llSleep(1);
        llSetPos(newposition);
             
         llResetScript();
      
}
}
/////////// END LISTEN EVENT


    /////////////////////////////////////////////////
    //
    // TOUCH_Start EVENT HANDLER
    //
    //  a stop/start toggle
    //
    //
    ////////////////////////////////////////////////
    touch_start( integer n)
    {
        switchpic();
    }

/////////////////////END DEFAULT STATE

}
