////////////////////////////////////
//
//
// Cube_of_Consonants_v12.2-os
// has NULL_KEY OWNER; restricted channel
// by wam7c macchi
//
// Adapted from "Picture Viewer" by Hiro Pendragon
// (get his display script freely available at ICT Library in Second Life).
// Valuable suggestions by Fred Huffhines of Stoney
//
//
// Freely distributed by Wamlabs Mediatronics of Catocala
//
/////////////////////////////////////


///////////////////////////////////////
//
//
// Bugs?
//
//
//
//
//
///////////////////////////////////////////

// stores the owner key of the object
key ownerkey;

// communication channel variable


integer cubeCHANNEL=22;


// cubename
string cubename = "cube";

// number of textures and sounds in the prim
integer numbertextures = 0;
integer numbersounds = 0;

// current texture and sound pointed to in the list
integer textureselected = 1;
integer soundselected = 1;

// set to llListen(cubeCHANNEL,"",NULL_KEY,""); in init()
integer storelisten = 0;

// values for changing text color

vector redText=<1.0,0.0,0.0>;
vector whiteText=<1.0,1.0,1.0>;
vector blackText=<0.0,0.0,0.0>;
vector greenText=<0.2,1.0,0.0>;
vector blueText=<0.0,0.4,1.0>;
vector textColor = <1.0,0.0,0.0>;

// value in seconds for llSetTimerEvent
integer switchtime = 15;

// used in switchtimeToggle() to toggle strt/stop
integer switchtimeOn = TRUE;

// used in algorithm to convert a rule number to a selected texture
integer ruleNum = 1;
integer goRule;


// used in Quiz state
integer randomWithZero = 0;
integer random = 0;

//
//
// UPDATE TEXT FUNCTION DEFINITION
// sets floating text (currently at maximum size)
// Plays sounds and sets textures
// llGetInventoryName
// string llGetInventoryName(integer type, index)
// Gets the name of the inventory item of the number of stated type.
//
updatetext()
{

    llSetText("\n1.ka;2.kha;3.ga;4.nga;\n5.ca;6.cha;7.ja;8.nya;\n9.ta;10.tha;11.da;12.na;\n
        13.pa;14.pha;15.ba;16.ma;\n17.tsa;18.tsha;19.dza;20.wa\n21.zha;22.za;23.'a;24.ya;\n
            25.ra;26.la;27.sha;28.sa;\n29.ha;30.a;\nClick Cube or Type '/" +(string)cubeCHANNEL+ "  help'", textColor, 1.0);

    llPlaySound(llGetInventoryName(INVENTORY_SOUND,(soundselected - 1)),1);

    llSetTexture(llGetInventoryName(INVENTORY_TEXTURE,(textureselected - 1)),ALL_SIDES);
}
//
// INIT FUNCTION DEFINITION
// Init() resets the listen handle and updates floating text
// also sets numbertextures and sounds
//
Init()
{

    llSay(0,"Cube of Consonants script reset!");
    numbertextures = llGetInventoryNumber(INVENTORY_TEXTURE);
    numbersounds = llGetInventoryNumber(INVENTORY_SOUND);
    updatetext();

    llListenRemove(storelisten);
    storelisten = llListen(cubeCHANNEL,"",NULL_KEY,"");

}

// changes touch_start() event
// to toggle: start(switchpic) / start(no switchpic)
switchtimeToggle()
{
    if (switchtimeOn==TRUE){
        switchtime = 0;  // remove current timer.
        llSetTimerEvent(switchtime);
        switchtimeOn=FALSE;
        llSay(0, "Timer is Off - Touch to Start Cube");
    }
    else if (switchtimeOn==FALSE){
        switchtime = 5;  // set timer.
        llSetTimerEvent(switchtime);
        switchtimeOn=TRUE;
        llSay(0, "Timer is On - " + (string)switchtime + " Seconds between Consonants");
        switchpic();
    }
}

//
// SWITCHPIC FUNCTION DEFINITION
//
// increments integer textureselected. textureselected will be
// a pointer to llGetInventoryName.
// tests to see if textureselected greater than numbertextures (of textures)
// subtracts numbertextures from textureselected, returning it to 1 (or zero?)

switchpic()
{
    textureselected++;
    soundselected++;
    if (textureselected > numbertextures || soundselected > numbersounds)
        textureselected = textureselected - numbertextures;
    soundselected = textureselected;
    updatetext();

}

///////////////////////////////////////////////////////
//
//
// ENTER DEFAULT
//
//
////////////////////////////////////////////////////////
default
{
    state_entry()
    {

        Init();
        switchtimeOn=FALSE;
        switchtime=0;
        llSetTimerEvent(switchtime);
        textColor = whiteText;
    }
    ///////////////////////////////////////////////////////
    //
    // ON_REZ EVENT HANDLER
    //
    // perhaps the object was in inventory, where it retains its previous state
    //
    //
    ////////////////////////////////////////////////////////
    on_rez(integer param)
    {
        Init();
        switchtimeOn=FALSE;
        switchtime=0;
        llSetTimerEvent(switchtime);

    }
    /////////////////////////////////////////////////////////
    //
    //
    // LISTEN EVENT HANDLER
    //
    //
    /////////////////////////////////////////////////////////
    listen(integer channel, string name, key id, string msg)
    {

        // notice (command, 0) is the first string typed and (command, 1) the second
        list command = llParseString2List(msg,[" "],[]);

        if(llList2String(command,0)=="help")
        {
            llSay(0,"Type /"+(string)cubeCHANNEL+ " plus 'goto <consonant number>'");
            llSay(0,"Type /"+(string)cubeCHANNEL+ " plus '<consonant>'");
            llSay(0,"Type /"+(string)cubeCHANNEL+ " plus 'stop'");
            llSay(0,"Type /"+(string)cubeCHANNEL+ " plus 'channel <new number>'");
            llSay(0,"Type /"+(string)cubeCHANNEL+ " plus 'info'");
            llSay(0,"Type /"+(string)cubeCHANNEL+ " plus 'color <white-red-black-green-blue>' ");
            llSay(0,"Type /"+(string)cubeCHANNEL+ " plus 'timer <number of seconds>'");
            llSay(0,"Type /"+(string)cubeCHANNEL+ " plus 'reset'");
            llSay(0,"Type /"+(string)cubeCHANNEL+ " plus 'debug'");
            llSay(0,"Type /"+(string)cubeCHANNEL+ " plus 'quiz'");
        }

        // typing debug reports these values
        else if(llList2String(command,0)=="debug")
        {
            llSay(0,"communication channel is " + (string)cubeCHANNEL);
            llSay(0,"textureselected equals " + (string)textureselected);
            llSay(0,"numbertextures equals " + (string)numbertextures);
            llSay(0,"soundselected equals " + (string)soundselected);
            llSay(0,"numbersounds equals " + (string)numbersounds);
            llSay(0,"switchtime equals " + (string)switchtime);
            llSay(0,"switchtimeOn equals " + (string)switchtimeOn);
            llSay(0,"text color equals " + (string)textColor);
            llSay(0,"ruleNum equals " + (string)ruleNum);
            llSay(0, "Memory is " + (string)llGetFreeMemory());



        }


        // stop
        else if(llList2String(command,0)=="stop")
        {
            switchtime = 0;
            switchtimeOn=FALSE;
            llSetTimerEvent(switchtime);
            llSay(0, "Restart with touch click");
        }
        // info
        else if(llList2String(command,0)=="info")
        {
            llSay(0,"Please visit 'http://wam7c.blip.tv' for video tutorial");
        }


        else if(llList2String(command,0)=="channel")
        {

            if((integer)llList2String(command,1)<1000)
            {
            cubeCHANNEL = (integer)llList2String(command,1);
            llSay(0,"New Communication Channel is "+(string)cubeCHANNEL);
            Init();
            }
            else if((integer)llList2String(command,1)>=1000)
            {
            llSay(0,"Please enter a number between 1 and 999");
            }

        }


        ///////////////////////////////
        /////////////////////////////// Quiz Module
        //////////////////////////////////
        else if(llList2String(command,0)=="quiz")
        {
            switchtime = 0;
            switchtimeOn=FALSE;
            llSetTimerEvent(switchtime);
            llSay(0, "You will see and hear a random consonant.");
            llSay(0, "Your job is to tell the Cube what that consonant is.");
            llSay(0, "But the Cube only knows the consonants' numbers.");
            llSay(0, "Refer to the floating text over the Cube for numbers.");
            llSay(0, "When ready for quiz type /"+(string)cubeCHANNEL+ " plus 'go'");
        }

        /////////////////////////////// jumps to new state

        else if(llList2String(command,0)=="go")

        {
            state quizGo;
        }
        ///////////////////////////////
        /////////////////////////////// end Quiz Module
        //////////////////////////////////

        ///////////////////////// reset color of floating text
        else if(llList2String(command,0)=="color")
        {
            if(llList2String(command,1)=="red")
            {
                textColor = redText;
            }
            else if(llList2String(command,1)=="white")
            {
                textColor = whiteText;
            }
            else if(llList2String(command,1)=="green")
            {
                textColor = greenText;
            }
            else if(llList2String(command,1)=="black")
            {
                textColor = blackText;
            }
            else if(llList2String(command,1)=="blue")
            {
                textColor = blueText;
            }
            updatetext();
        }

        ///////////////////////////// set texture-switching interval in seconds
        else if(llList2String(command,0)=="timer")
        {
            switchtime = (integer)llList2String(command,1);
            llSetTimerEvent(switchtime);
            llSay(0,"Cube switches every "+(string)switchtime+" seconds.");
        }

        ////////////////////////////////////////
        //
        // set Cube to specific consonant based on its number
        //
        // formula for finding a numbered rule thanks to Al Magee.
        // This formula also works with multiple-texture rules
        // if number of textures in each rule is constant throughout.
        // In the Cube, there is only 1 texture per consonant so this is not really needed
        // p = 5(x-1) + 2
        // p = desired slide; 5 = # slides in each rule;
        // x = rule number; 2 = starting number of 1st rule + 1
        //
        ////////////////////////////////////////
        else if(llList2String(command,0)=="goto")
        {
            integer goRule = ruleNum;            
            ruleNum = (integer)llList2String(command,1);
            goRule = (1 * (ruleNum-1))+2;
            textureselected = goRule;
            soundselected = textureselected;
            switchtime = 0;
            llSetTimerEvent(switchtime);
            llSay(0,"Cube set to Consonant "+(string)ruleNum);
            updatetext();
        }
        else if(llList2String(command,0)=="reset")
        {
            llResetScript();
        }

        /////////// Set Cube to specific consonant based on its name
        ////////// Here we listen for the 30 consonant names
        ////////// Is there a better way to do this?


        else if(llList2String(command,0)=="ka")
        {
          integer textureselected = 2;
          integer soundselected = textureselected;
          switchtime = 0;
          llSetTimerEvent(switchtime);
          updatetext();
        }


        else if(llList2String(command,0)=="kha")
        {
            textureselected = 3;
            soundselected = textureselected;
            switchtime = 0;
            llSetTimerEvent(switchtime);
            updatetext();
        }


        else if(llList2String(command,0)=="ga")
        {
            textureselected = 4;
            soundselected = textureselected;
            switchtime = 0;
            llSetTimerEvent(switchtime);
            updatetext();
        }


        else if(llList2String(command,0)=="nga")
        {
            textureselected = 5;
            soundselected = textureselected;
            switchtime = 0;
            llSetTimerEvent(switchtime);
            updatetext();
        }


        else if(llList2String(command,0)=="ca")
        {
            textureselected = 6;
            soundselected = textureselected;
            switchtime = 0;
            llSetTimerEvent(switchtime);
            updatetext();
        }


        else if(llList2String(command,0)=="cha")
        {
            textureselected = 7;
            soundselected = textureselected;
            switchtime = 0;
            llSetTimerEvent(switchtime);
            updatetext();
        }


        else if(llList2String(command,0)=="ja")
        {
            textureselected = 8;
            soundselected = textureselected;
            switchtime = 0;
            llSetTimerEvent(switchtime);
            updatetext();
        }


        else if(llList2String(command,0)=="nya")
        {
            textureselected = 9;
            soundselected = textureselected;
            switchtime = 0;
            llSetTimerEvent(switchtime);
            updatetext();
        }


        else if(llList2String(command,0)=="ta")
        {
            textureselected = 10;
            soundselected = textureselected;
            switchtime = 0;
            llSetTimerEvent(switchtime);
            updatetext();
        }


        else if(llList2String(command,0)=="tha")
        {
            textureselected = 11;
            soundselected = textureselected;
            switchtime = 0;
            llSetTimerEvent(switchtime);
            updatetext();
        }


        else if(llList2String(command,0)=="da")
        {
            textureselected = 12;
            soundselected = textureselected;
            switchtime = 0;
            llSetTimerEvent(switchtime);
            updatetext();
        }


        else if(llList2String(command,0)=="na")
        {
            textureselected = 13;
            soundselected = textureselected;
            switchtime = 0;
            llSetTimerEvent(switchtime);
            updatetext();
        }


        else if(llList2String(command,0)=="pa")
        {
            textureselected = 14;
            soundselected = textureselected;
            switchtime = 0;
            llSetTimerEvent(switchtime);
            updatetext();
        }


        else if(llList2String(command,0)=="pha")
        {
            textureselected = 15;
            soundselected = textureselected;
            switchtime = 0;
            llSetTimerEvent(switchtime);
            updatetext();
        }


        else if(llList2String(command,0)=="ba")
        {
            textureselected = 16;
            soundselected = textureselected;
            switchtime = 0;
            llSetTimerEvent(switchtime);
            updatetext();
        }


        else if(llList2String(command,0)=="ma")
        {
            textureselected = 17;
            soundselected = textureselected;
            switchtime = 0;
            llSetTimerEvent(switchtime);
            updatetext();
        }


        else if(llList2String(command,0)=="tsa")
        {
            textureselected = 18;
            soundselected = textureselected;
            switchtime = 0;
            llSetTimerEvent(switchtime);
            updatetext();
        }


        else if(llList2String(command,0)=="tsha")
        {
            textureselected = 19;
            soundselected = textureselected;
            switchtime = 0;
            llSetTimerEvent(switchtime);
            updatetext();
        }


        else if(llList2String(command,0)=="dza")
        {
            textureselected = 20;
            soundselected = textureselected;
            switchtime = 0;
            llSetTimerEvent(switchtime);
            updatetext();
        }


        else if(llList2String(command,0)=="wa")
        {
            textureselected = 21;
            soundselected = textureselected;
            switchtime = 0;
            llSetTimerEvent(switchtime);
            updatetext();
        }


        else if(llList2String(command,0)=="zha")
        {
            textureselected = 22;
            soundselected = textureselected;
            switchtime = 0;
            llSetTimerEvent(switchtime);
            updatetext();
        }


        else if(llList2String(command,0)=="za")
        {
            textureselected = 23;
            soundselected = textureselected;
            switchtime = 0;
            llSetTimerEvent(switchtime);
            updatetext();
        }


        else if(llList2String(command,0)=="'a")
        {
            textureselected = 24;
            soundselected = textureselected;
            switchtime = 0;
            llSetTimerEvent(switchtime);
            updatetext();
        }


        else if(llList2String(command,0)=="ya")
        {
            textureselected = 25;
            soundselected = textureselected;
            switchtime = 0;
            llSetTimerEvent(switchtime);
            updatetext();
        }


        else if(llList2String(command,0)=="ra")
        {
            textureselected = 26;
            soundselected = textureselected;
            switchtime = 0;
            llSetTimerEvent(switchtime);
            updatetext();
        }


        else if(llList2String(command,0)=="la")
        {
            textureselected = 27;
            soundselected = textureselected;
            switchtime = 0;
            llSetTimerEvent(switchtime);
            updatetext();
        }


        else if(llList2String(command,0)=="sha")
        {
            textureselected = 28;
            soundselected = textureselected;
            switchtime = 0;
            llSetTimerEvent(switchtime);
            updatetext();
        }


        else if(llList2String(command,0)=="sa")
        {
            textureselected = 29;
            soundselected = textureselected;
            switchtime = 0;
            llSetTimerEvent(switchtime);
            updatetext();
        }


        else if(llList2String(command,0)=="ha")
        {
            textureselected = 30;
            soundselected = textureselected;
            switchtime = 0;
            llSetTimerEvent(switchtime);
            updatetext();
        }


        else if(llList2String(command,0)=="a")
        {
            textureselected = 31;
            soundselected = textureselected;
            switchtime = 0;
            llSetTimerEvent(switchtime);
            updatetext();
        }
        ///////////// end listening for consonant names
    }
    // END LISTEN EVENT


    /////////////////////////////////////////////////
    //
    // TOUCH_Start EVENT HANDLER
    //
    //  a stop/start toggle
    //
    //
    ////////////////////////////////////////////////
    touch_start( integer n)
    {
        switchtimeToggle();
    }


    //////////////////////////////////////////////////
    //
    //
    // TIMER EVENT HANDLER
    //
    //
    /////////////////////////////////////////////////////
    timer()
    {
        switchpic();
    }
}
/////////////////////END DEFAULT STATE

/////////////////////////////// ENTER QUIZ STATE
state quizGo

{
    state_entry()
    {
        llSay(0, "Quiz state entered");
        randomWithZero = (integer)llFrand(29.0);
        random = randomWithZero + 1;
        textureselected = random;
        soundselected = textureselected;
        llPlaySound(llGetInventoryName(INVENTORY_SOUND,(soundselected)),1);
        llSetTexture(llGetInventoryName(INVENTORY_TEXTURE,(textureselected)),ALL_SIDES);
        llSay(0, "What consonant is this? Enter /"+(string)cubeCHANNEL+ " plus its number.");
        llListen(cubeCHANNEL, "", NULL_KEY, "" );
    }

    listen(integer channel, string name, key id, string message)
    {
        if (llToLower(message) == (string)random)
        {
            llSay(0,"Correct. You know your Tibetan consonants!");
            llSleep(2.0);
            llResetScript();
        }
        else
        {
            llSay(0, "Sorry, the correct answer is " + (string)random);
            llSay(0, "Your answer was "+ message);
            llSay(0, "Please try again.");
            llSleep(2.0);
            llResetScript();
        }

    }




}