
// Drop this script in any prim that contains animations, to check the animations' permissions.
// Prints a warning for each animation that is copy/xfer for next owner.
// Deletes itself when done.
//
// Chaz Longstaff, June 2008.
// Lear Cale: made to delete self on exit, other minor simplifications


integer AllowMod = FALSE;       // set to TRUE if you want to allow mod permissions on anims

checkPerms() {
    integer perms;
    integer ix;
    integer numWarnings;
    string  anim;
    list    copy;
    list    xfer;
    list    mod;

    integer num = llGetInventoryNumber(INVENTORY_ANIMATION);
    llSay(0, "Checking that anims are not copy/xfer for next owner");

    for (ix = 0; ix < num; ++ix) {
        anim = llGetInventoryName(INVENTORY_ANIMATION, ix);
        perms = llGetInventoryPermMask(anim, MASK_NEXT);

        if ((perms & PERM_COPY) && (perms & PERM_TRANSFER)) {
            llSay(0, "'" + anim + "' is copy/xfer");
            ++numWarnings;
        } else {
                if (perms & PERM_COPY) {
                    copy += anim;
                }
            if (perms & PERM_TRANSFER) {
                xfer += anim;
            }
            if (perms & PERM_MODIFY) {
                mod += anim;
            }
        }
    }

    integer numCopy = llGetListLength(copy);
    integer numXfer = llGetListLength(xfer);

    if (numCopy && numXfer) {
        llSay(0, "Warning: you've mixed no-copy and no-xfer anims");
        if (numCopy < numXfer) {
            llSay(0, "Copy/no-xfer anims: " + llList2CSV(copy));
        } else {
                llSay(0, "Xfer/no-copy anims: " + llList2CSV(xfer));
        }
    } else if (numXfer == 0) {
            llSay(0, "No transferrable animations.");
    } else if (numXfer == 0) {
            llSay(0, "No copiable animations.");
    }

    if (! AllowMod && llGetListLength(mod)) {
        llSay(0, "Modifiable anims: " + llList2CSV(mod));
    } else {
            llSay(0, "No modifiable animations.");
    }

    llSay(0, (string) num + " animations");
}

integer is_packaged()
{
    list PackageContents_l = ["..MLP Tools - README", ".MENUITEMS.reorient", ".XCITE.example", ".XCITEANIMS.example"];
    integer Count_i = llGetListLength(PackageContents_l);
    integer i;
    for (i=0;i<Count_i;++i)
    {
        if (llGetInventoryType(llList2String(PackageContents_l, i)) == -1) { return FALSE; }
    }
    return TRUE;
}

default {
    state_entry() {
        if (is_packaged()) { return; }
        checkPerms();
        llSay(0, "Permission checks complete, deleting script.");
        llRemoveInventory(llGetScriptName());
    }
}