integer  REZZER_CHANNEL  = -1213210;
integer  gRezzerNumber;
integer  gRezzerChannel;
integer  gRCommId;
vector   gOffset;
rotation gRotation;
vector   gDestPos;
rotation gDestRot;
integer  gSimLocation;
integer  gMoveFlag;


integer get_desc_info()
{
    //FORMAT:  gRezzerNumber|vOffset|gRotation|gSimLocation
    string tempString = llGetObjectDesc();
    if (llStringLength(tempString) < 5)
        return FALSE;
        
    list tempList = llParseString2List(tempString, ["#"], []);
    gRezzerNumber = (integer)llList2String(tempList, 0);
    gOffset = (vector)llList2String(tempList, 1);
    gRotation = (rotation)llList2String(tempList, 2);
    gSimLocation = (integer)llList2String(tempList, 3);
    return TRUE;
}


set_comm_channel()
{
    llListenRemove(gRCommId);
    gRezzerChannel = REZZER_CHANNEL + gRezzerNumber;
    gRCommId = llListen(gRezzerChannel, "", NULL_KEY, "");
    string tempString = llGetObjectDesc();
    if (llStringLength(tempString) > 10)
    {
        list tempList = llParseString2List(tempString, ["#"], []);
        gOffset = (vector)llList2String(tempList, 1);
        gRotation = (rotation)llList2String(tempList, 2);
        gSimLocation = (integer)llList2String(tempList, 3);
        llSetObjectDesc((string)gRezzerNumber + "#" + (string)gOffset + "#" + (string)gRotation + "#" + (string)gSimLocation);
    }  
}
    

start_move(vector basePos, rotation baseRot, key id)
{
    if(get_desc_info())
    {
        if(gSimLocation == FALSE) 
        {
            gDestPos = (gOffset * baseRot) + basePos;
            gDestRot = gRotation * baseRot;
        } 
        else 
        {
            gDestPos = gOffset;
            gDestRot = gRotation;
        }

        if(gDestPos.x < 0.0) 
            gDestPos.x = 0.0;
        if(gDestPos.x > 255.0) 
            gDestPos.x = 255.0;
        if(gDestPos.y < 0.0) 
            gDestPos.y = 0.0;
        if(gDestPos.y > 255.0) 
            gDestPos.y = 255.0;
        if(gDestPos.z > 4096.0) 
            gDestPos.z = 4096.0;
    
        do_move();
    }
    else
        llOwnerSay("ERRORMOVE:  position not yet recorded?");
}


do_move()
{
    if (gDestPos != llGetPos())
    {
        list params = [];
        integer hops = llAbs((integer)llCeil(llVecDist(llGetPos(), gDestPos) / 10.0));
        integer x;
        for( x = 0; x < hops; x++ ) 
            params+= [PRIM_POSITION, gDestPos];
        llSetPrimitiveParams(params);
        
        if(gMoveFlag)
        { 
            llRegionSay(gRezzerChannel, "ATDEST");
            gMoveFlag = FALSE;
        }
    }
    llSetRot(gDestRot);
}


default
{
    state_entry()
    {
        gRezzerNumber = (integer)llGetObjectDesc();
        if (gRezzerNumber == 0)
        {
            gRezzerNumber = 1;
            llSetObjectDesc("1");
        }
        set_comm_channel();
        state running;
    }
}


state running
{
    on_rez(integer start_param)
    {
        if (start_param > 0)
        { 
            gRezzerNumber = start_param;
            set_comm_channel();
            gMoveFlag = TRUE;
            llRegionSay(gRezzerChannel, "READYTOPOS");
        }
    }
    
    state_entry()
    {
        set_comm_channel();
    }
    
    listen(integer channel, string name, key id, string message)
    {
        if(message == "FINISHED") // message format: "FINISHED"
        {
            llSetObjectDesc(" ");
            llRemoveInventory(llGetScriptName());
        }
        else
        if(message == "CLEAN") // message format: "CLEAN | gRezzerNumber"
        {
            llDie();
        }
        else
        if(message == "RESET") // message format: "RESET"
        {
            llSetObjectDesc(" ");
            llResetScript();
        }
        else
        if(message == "UNRECORD") // message format: "UNRECORD"
        {
            llSetObjectDesc(" ");
        }
        else
        if(message == "RECORDSIM") // message format: "RECORDSIM"
        {
            gRotation = llGetRot();
            gOffset = llGetPos();
            gSimLocation = TRUE;
            llSetObjectDesc((string)gRezzerNumber + "#" + (string)gOffset + "#" + (string)gRotation + "#" + (string)gSimLocation);
            llOwnerSay("Recorded sim position.");
        }
        else
        {
            list tempList = llParseString2List(message, ["|"], []);
            string command = llList2String(tempList,0);
            if (command == "CHANNEL")
            {
                gRezzerNumber = (integer)llList2String(tempList, 1);
                set_comm_channel();   
            }
            if (command == "CLEAN")  // message format: "CLEAN|channel"
            {
                if (gRezzerNumber == (integer)llList2String(tempList, 1))
                    llDie();
            }
            else
            if (command == "RECORD" || command == "MOVE" || command == "MOVESINGLE")
            {
                vector basePos = (vector)llList2String(tempList, 1);
                rotation baseRot = (rotation)llList2String(tempList, 2);
                if(command == "RECORD") // message format: "RECORD | base position | base rotation"
                {
                    gOffset = (llGetPos() - basePos) / baseRot;
                    gRotation = llGetRot() / baseRot;
                    gSimLocation = FALSE;
                    llSetObjectDesc((string)gRezzerNumber + "#" + (string)gOffset + "#" + (string)gRotation + "#" + (string)gSimLocation);
                    llOwnerSay("Recorded position.");
                }
                else
                if(command == "MOVE") // message format: "MOVE | base position | base rotation"
                    start_move(basePos, baseRot, id);
                else
                if(command == "MOVESINGLE" && gMoveFlag) // message format: "MOVESINGLE | base position | base rotation"
                    start_move(basePos, baseRot, id);
            }
        }
    }
}