// Script Name: Lighting_System.lsl
// Author: Rene
//- Sets light properties: color, intensity, radius, falloff
//- Sets prim properties: color, alpha, glow, fullbright
//- Color and alpha can be set for both ON and OFF states
//- Linkset or region
//- Touch to turn light on or off
//- Long touch to show menu
//- Supports light groups
//- Supports link messages from other scripts

// Downloaded from : http://www.free-lsl-scripts.com/freescripts.plx?ID=1605

// This program is free software; you can redistribute it and/or modify it.
// License information must be included in any script you give out or use.
// This script is licensed under the Creative Commons Attribution-Share Alike 3.0 License
// from http://creativecommons.org/licenses/by-sa/3.0 unless licenses are
// included in the script or comments by the original author,in which case
// the authors license must be followed.

// Please leave any authors credits intact in any script you use or publish.
////////////////////////////////////////////////////////////////////
// Lighting System - Light
//
// Author: Rene Schrama
// Date: 01-08-2011
// Project content: switch.lsl, light.lsl
//
// THIS SCRIPT WAS DEVELOPED IN OPENSIM AND CANNOT BE GUARANTEED TO WORK ANYWHERE ELSE. USE AT YOUR OWN RISK.
//
// This work is licensed under the Creative Commons Attribution-ShareAlike 3.0 Unported (CC BY-SA 3.0) License.
// To view a copy of this license, visit http://creativecommons.org/licenses/by-sa/3.0/.
//
// See switch.lsl for feature list

string title = "Floor Lamp";      // title
string version = "1.0";           // version

// ==================================================================================================
// Constants (change to suit your own taste)

integer linkSet = FALSE;           // works for linkset if TRUE, works for region if FALSE
integer debug = FALSE;            // show debug messages

// ==================================================================================================

// Constants (do NOT change!)

integer switchChannel = -223;   // switch channel

// Variables

key owner;                        // object owner

// Functions

string getGroup()
{
    string str = llStringTrim(llGetObjectDesc(), STRING_TRIM);
    if (llToLower(str) == "(no description)" || str == "") str = "Default";
    return str;
}

unpackMessage(string msg)
{
    list msgList = llCSV2List(msg);
    string group = llList2String(msgList, 0);
    if (llToLower(group) != llToLower(getGroup())) return;

    integer on = (integer)llList2String(msgList, 1);
    vector color = (vector)llList2String(msgList, 2);
    float intensity = (float)llList2String(msgList, 3);
    float radius = (float)llList2String(msgList, 4);
    float falloff = (float)llList2String(msgList, 5);
    float alpha = (float)llList2String(msgList, 6);
    float glow = (float)llList2String(msgList, 7);
    integer fullbright = (integer)llList2String(msgList, 8);

    llSetPrimitiveParams([
        PRIM_POINT_LIGHT, on, color, intensity, radius, falloff,
        PRIM_COLOR, ALL_SIDES, color, alpha,
        PRIM_GLOW, ALL_SIDES, glow,
        PRIM_FULLBRIGHT, ALL_SIDES, fullbright]);
}

default
{
    state_entry()
    {
        owner = llGetOwner();
        llWhisper(0, title + " " + version + " ready");
        llWhisper(0, (string)llGetFreeMemory() + " bytes free");

        if (linkSet) {
            llWhisper(0, "Currently running in LINKSET mode");
            state sLinkSet;
        }
        else {
            llWhisper(0, "Currently running in REGION mode");
            state sRegion;
        }
    }

    on_rez(integer start_param)
    {
        llResetScript();
    }
}

state sLinkSet
{
    link_message(integer sender_number, integer number, string msg, key id)
    {
        if (debug) llOwnerSay("LINK_MESSAGE event: " + (string)number + "; " + msg + "; " + id);

        if (number == switchChannel) {
            unpackMessage(msg);
        }
    }
}

state sRegion
{
    state_entry()
    {
        llListen(switchChannel, "", "", "");
    }

    listen(integer channel, string name, key id, string msg)
    {
        if (debug) llOwnerSay("LISTEN event: " + (string)channel + "; " + msg);

        if (channel == switchChannel) {
            if (llGetOwnerKey(id) == owner) unpackMessage(msg);
        }
    }
}

