// Script Name: Lighting_System.lsl
// Author: Rene
//- Sets light properties: color, intensity, radius, falloff
//- Sets prim properties: color, alpha, glow, fullbright
//- Color and alpha can be set for both ON and OFF states
//- Linkset or region
//- Touch to turn light on or off
//- Long touch to show menu
//- Supports light groups
//- Supports link messages from other scripts

// Downloaded from : http://www.free-lsl-scripts.com/freescripts.plx?ID=1605

// This program is free software; you can redistribute it and/or modify it.
// License information must be included in any script you give out or use.
// This script is licensed under the Creative Commons Attribution-Share Alike 3.0 License
// from http://creativecommons.org/licenses/by-sa/3.0 unless licenses are
// included in the script or comments by the original author,in which case
// the authors license must be followed.

// Please leave any authors credits intact in any script you use or publish.
////////////////////////////////////////////////////////////////////
// Lighting System - Switch
//
// Author: Rene Schrama
// Date: 01-08-2011
// Project content: switch.lsl, light.lsl
//
// CHANGELOG:
// V1.01
// ------------------------
// Author: Oddball Otoole
// Date: 22-08-2011
//
// Changed script so that when lights are OFF, the (lightbeam) prims are 100% transparent.
// ------------------------
//
// THIS SCRIPT WAS DEVELOPED IN OPENSIM AND CANNOT BE GUARANTEED TO WORK ANYWHERE ELSE. USE AT YOUR OWN RISK.
//
// This work is licensed under the Creative Commons Attribution-ShareAlike 3.0 Unported (CC BY-SA 3.0) License.
// To view a copy of this license, visit http://creativecommons.org/licenses/by-sa/3.0/.
//
// - Sets light properties: color, intensity, radius, falloff
// - Sets prim properties: color, alpha, glow, fullbright
// - Color and alpha can be set for both ON and OFF states
// - Linkset or region
// - Touch to turn light on or off
// - Long touch to show menu
// - Supports light groups
// - Supports link messages from other scripts

string title = "Floor Lamp";    // title
string version = "1.0";           // version

// ==================================================================================================
// Constants (change to suit your own taste)

integer linkSet = FALSE;           // works for linkset if TRUE, works for region if FALSE
integer msgNumber = 12345;        // number part of incoming link messages
string msgSwitch = "on/off";      // string part of incoming link message: switch (on/off)
string msgMenu = "menu";          // string part of incoming link message: show menu
integer percent = 10;             // how much to increase/decrease (%) on every click of a +/- button
integer debug = FALSE;            // show debug messages

// ==================================================================================================

// Constants (do NOT change!)

integer switchChannel = -223;   // switch channel
float maxRed = 1.0;               // max. red
float maxGreen = 1.0;             // max. green
float maxBlue = 1.0;              // max. blue
float maxIntensity = 1.0;         // max. light intensity
float maxRadius = 20.0;           // max. light radius
float maxFalloff = 2.0;           // max. light falloff
float maxGlow = 1.0;              // max. prim glow
float maxAlpha = 1.0;             // max. prim alpha

// Variables

key owner;                        // object owner
key user;                         // key of last avatar to touch object
float scriptTime;                 // script time
integer menuChannel;              // main menu channel
integer colorChannel;             // color menu channel
integer menuHandle;               // handle for main menu listener
integer colorHandle;              // handle for color menu listener
integer on = FALSE;               // on-off switch
integer perRed;                   // percent red
integer perGreen;                 // percent green
integer perBlue;                  // percent blue
integer perAlpha;                 // percent prim alpha
integer perRedOff;                // percent red when OFF
integer perGreenOff;              // percent green when OFF
integer perBlueOff;               // percent blue when OFF
integer perAlphaOff;              // percent prim alpha when OFF
integer perIntensity;             // percent light intensity
integer perRadius;                // percent light radius
integer perFalloff;               // percent light falloff
integer perGlow;                  // percent prim glow
integer fullbright = TRUE;        // fullbright

// Functions

menuDialog (key id)
{
    string strOn = "OFF"; if (on) strOn = "ON";
    string strLinkSet = "REGION"; if (linkSet) strLinkSet = "LINKSET";
    string strFullbright = "NO"; if (fullbright) strFullbright = "YES";
    menuChannel = (integer)(llFrand(-1000000000.0) - 1000000000.0);
    llListenRemove(menuHandle);
    menuHandle = llListen(menuChannel, "", "", "");
    llSetTimerEvent(0);
    llSetTimerEvent(300);
    llDialog(id, title + " " + version +
        "\n\nIntensity: " + (string)perIntensity + "%\t\tState: " + strOn +
        "\nRadius: " + (string)perRadius + "%\t\tFullbright: " + strFullbright +
        "\nFalloff: " + (string)perFalloff + "%\t\tMode: " + strLinkSet +
        "\nGlow: " + (string)perGlow + "%\t\tGroup: " + getGroup(), [
        "-Glow",      "+Glow",      "On/Off",
        "-Falloff",   "+Falloff",   "Reset",
        "-Radius",    "+Radius",    "Fullbright",
        "-Intensity", "+Intensity", "Color" ],
        menuChannel);
}

colorDialog (key id)
{
    colorChannel = (integer)(llFrand(-1000000000.0) - 1000000000.0);
    llListenRemove(colorHandle);
    colorHandle = llListen(colorChannel, "", "", "");
    llSetTimerEvent(0);
    llSetTimerEvent(300);
    if (on) {
        llDialog(id, "Color & Alpha when ON" +
            "\n\nRed: " + (string)perRed + "%" +
            "\nGreen: " + (string)perGreen + "%" +
            "\nBlue: " + (string)perBlue + "%" +
            "\nAlpha: " + (string)perAlpha + "%", [
            "-Alpha", "+Alpha", "Main menu",
            "-Blue",  "+Blue",  "B min/max",
            "-Green", "+Green", "G min/max",
            "-Red",   "+Red",   "R min/max" ],
            colorChannel);
    }
    else {
        llDialog(user, "Color & Alpha when OFF" +
            "\n\nRed: " + (string)perRedOff + "%" +
            "\nGreen: " + (string)perGreenOff + "%" +
            "\nBlue: " + (string)perBlueOff + "%" +
            "\nAlpha: " + (string)perAlphaOff + "%", [
            "-Alpha", "+Alpha", "Main menu",
            "-Blue",  "+Blue",  "B min/max",
            "-Green", "+Green", "G min/max",
            "-Red",   "+Red",   "R min/max" ],
            colorChannel);
    }
}

string getGroup()
{
    string str = llStringTrim(llGetObjectDesc(), STRING_TRIM);
    if (llToLower(str) == "(no description)" || str == "") str = "Default";
    return str;
}

float percentage (integer per, float num)
{
    return num / 100.0 * (float)per;
}

integer min (integer x, integer y)
{
    if (x < y) return x; else return y;
}

integer max (integer x, integer y)
{
    if (x > y) return x; else return y;
}

reset()
{
    perRed = 100;
    perGreen = 100;
    perBlue = 100;
    perAlpha = 100;
    perRedOff = 100;
    perGreenOff = 100;
    perBlueOff = 100;
    perAlphaOff = 100;
    perIntensity = 100;
    perRadius = 50;
    perFalloff = 40;
    perGlow = 0;
    fullbright = TRUE;
}

sendMessage(string group)
{
    vector color;
    float intensity;
    float radius;
    float falloff;
    float alpha;
    float glow;
    integer fullbr;

    if (on) {
        color.x = percentage(perRed, maxRed);
        color.y = percentage(perGreen, maxGreen);
        color.z = percentage(perBlue, maxBlue);
        intensity = percentage(perIntensity, maxIntensity);
        radius = percentage(perRadius, maxRadius);
        falloff = percentage(perFalloff, maxFalloff);
        alpha = percentage(perAlpha, maxAlpha);
        glow = percentage(perGlow, maxGlow);
        fullbr = fullbright;
    }
    else {
        color.x = percentage(perRedOff, maxRed);
        color.y = percentage(perGreenOff, maxGreen);
        color.z = percentage(perBlueOff, maxBlue);
        alpha = 0.0;
        glow = 0.0;
        fullbr = FALSE;
    }

    list msgList = [group] + [on] + [color] + [intensity] + [radius] + [falloff] + [alpha] + [glow] + [fullbr];
    string msg = llList2CSV(msgList);

    if (linkSet) llMessageLinked(LINK_SET, switchChannel, msg, "");
    else llRegionSay(switchChannel, msg);
}

default
{
    state_entry()
    {
        owner = llGetOwner();
        reset();
        sendMessage(getGroup());
        llSetText(title, <1.0, 1.0, 1.0>, 1.0);
        llWhisper(0, title + " " + version + " ready");
        llWhisper(0, (string)llGetFreeMemory() + " bytes free");
        llWhisper(0, "Touch to turn light on or off");
        llWhisper(0, "Long touch to show menu");
        if (linkSet) llWhisper(0, "Currently running in LINKSET mode");
        else llWhisper(0, "Currently running in REGION mode");
    }

    on_rez(integer start_param)
    {
        llResetScript();
    }

    touch_start(integer total_number)
    {
        scriptTime = llGetTime();
    }

    touch_end(integer total_number)
    {
        user = llDetectedKey(0);

        if (llGetTime() - scriptTime > 1.0) {
            menuDialog(user);
        }
        else {
            if (on) on = FALSE; else on = TRUE;
            sendMessage(getGroup());
        }
    }

    listen(integer channel, string name, key id, string msg)
    {
        llSetTimerEvent(0);
        if (debug) llOwnerSay("LISTEN event: " + (string)channel + "; " + msg);

        if (channel == menuChannel) {
            llListenRemove(menuHandle);
            if (msg == "-Intensity") perIntensity = max(perIntensity - percent, 0);
            else if (msg == "-Radius") perRadius = max(perRadius - percent, 0);
            else if (msg == "-Falloff") perFalloff = max(perFalloff - percent, 0);
            else if (msg == "-Glow") perGlow = max(perGlow - percent, 0);
            else if (msg == "+Intensity") perIntensity = min(perIntensity + percent, 100);
            else if (msg == "+Radius") perRadius = min(perRadius + percent, 100);
            else if (msg == "+Falloff") perFalloff = min(perFalloff + percent, 100);
            else if (msg == "+Glow") perGlow = min(perGlow + percent, 100);
            else if (msg == "Color") colorDialog(user);
            else if (msg == "Fullbright") { if (fullbright) fullbright = FALSE; else fullbright = TRUE; }
            else if (msg == "Reset") reset();
            else if (msg == "On/Off") { if (on) on = FALSE; else on = TRUE; }
            if (msg != "Color") {
                sendMessage(getGroup());
                menuDialog(user);
            }
        }
        else if (channel == colorChannel) {
            llListenRemove(colorHandle);
            if (on) {
                if (msg == "-Red") perRed = max(perRed - percent, 0);
                else if (msg == "-Green") perGreen = max(perGreen - percent, 0);
                else if (msg == "-Blue") perBlue = max(perBlue - percent, 0);
                else if (msg == "-Alpha") perAlpha = max(perAlpha - percent, 0);
                else if (msg == "+Red") perRed = min(perRed + percent, 100);
                else if (msg == "+Green") perGreen = min(perGreen + percent, 100);
                else if (msg == "+Blue") perBlue = min(perBlue + percent, 100);
                else if (msg == "+Alpha") perAlpha = min(perAlpha + percent, 100);
                else if (msg == "R min/max") { if (perRed) perRed = 0; else perRed = 100; }
                else if (msg == "G min/max") { if (perGreen) perGreen = 0; else perGreen = 100; }
                else if (msg == "B min/max") { if (perBlue) perBlue = 0; else perBlue = 100; }
                else if (msg == "Main menu") menuDialog(user);
            }
            else {
                if (msg == "-Red") perRedOff = max(perRedOff - percent, 0);
                else if (msg == "-Green") perGreenOff = max(perGreenOff - percent, 0);
                else if (msg == "-Blue") perBlueOff = max(perBlueOff - percent, 0);
                else if (msg == "-Alpha") perAlphaOff = max(perAlphaOff - percent, 0);
                else if (msg == "+Red") perRedOff = min(perRedOff + percent, 100);
                else if (msg == "+Green") perGreenOff = min(perGreenOff + percent, 100);
                else if (msg == "+Blue") perBlueOff = min(perBlueOff + percent, 100);
                else if (msg == "+Alpha") perAlphaOff = min(perAlphaOff + percent, 100);
                else if (msg == "R min/max") { if (perRedOff) perRedOff = 0; else perRedOff = 100; }
                else if (msg == "G min/max") { if (perGreenOff) perGreenOff = 0; else perGreenOff = 100; }
                else if (msg == "B min/max") { if (perBlueOff) perBlueOff = 0; else perBlueOff = 100; }
                else if (msg == "Main menu") menuDialog(user);
            }
            if (msg != "Main menu") {
                sendMessage(getGroup());
                colorDialog(user);
            }
        }
    }

    link_message(integer sender_number, integer number, string msg, key id)
    {
        if (debug) llOwnerSay("LINK_MESSAGE event: " + (string)number + "; " + msg + "; " + id);

        if (number == msgNumber) {
            if (msg == msgSwitch) {
                if (on) on = FALSE; else on = TRUE;
                sendMessage(getGroup());
            }
            else if (msg == msgMenu) {
                if (id) {
                    user = id;
                    menuDialog(user);
                }
                else {
                    llWhisper(0, "A valid avatar key must be provided in the link message.");
                }
            }
        }
    }

    timer()
    {
        llSetTimerEvent(0);
        llListenRemove(menuHandle);
        llListenRemove(colorHandle);
        if (debug) llOwnerSay("MENU TIMEOUT");
    }
}

