integer REZZER_CHANNEL  = -1213210;
integer VENDOR_CHANNEL  = -1925670;
integer MAX_CHANNEL     = 99;
integer MIN_CHANNEL     = 1;
float   REZ_DELAY       = 1.00;
float   TIMER_RATE      = 0.5;
float   TIMER_EVENT     = 25.0;

integer  gStartParam;
integer  gRCommId;
integer  gRCommChannel;
integer  gRezzerNumber;
integer  gVCommId;
integer  gVCommChannel;
integer  gVendorNumber;
integer  gMenuChannel;
integer  gListenId;

// menu options and locations
string  gRecord   = "Record";
string  gBuild    = "Build";
string  gFinish   = "Finish";
string  gChannel  = "Channel";
string  gGroupOn  = "Group: off";
string  gGroupOff  = "Group: on";
integer gGroupLoc;
string  gChatOn   = "Chat: on";
string  gChatOff  = "Chat: off";
integer gChatLoc;
string  gPosRez   = "Pos: Rezzer";
string  gPosSim   = "Pos: Sim";
integer gPosLoc;
string  gUnRecord = "UnRecord";
string  gClean    = "Clean";
string  gReset    = "Reset";
string  gBack     = "<<Back";
string  gExit     = "Exit";

//Misc info
list     gMenuList;
list     gCreatorList;
list     gOwnerList;
list     gChannelList;
integer  gIndex;
vector   gLastPos;
rotation gLastRot;
key      gCreator;
key      gOwner;
key      gAvaKey;

// multi-vendor rezzer info
vector   gRezzerOffset;
rotation gRezzerRotation;


give_message(key id, string message)
{
    if (llList2String(gMenuList, gChatLoc) == gChatOn)
    {
        if (id == llGetOwner())
            llOwnerSay(message);
        else
            llInstantMessage(id, message);
    }
}


string set_menu_string()
{
    string message = "";
    if (gCreator == gOwner)
        message += "Record  :  Record all Components Locations\n";
    message += "Build    : Build Building\n";
    message += "Finish   : Build Finished, Remove scripts\n";
    
    message += "Group   : Group Access is ";
    if (llList2String(gMenuList, gGroupLoc) == gGroupOn)
        message += "on\n";
    else
        message += "off\n";
        
    if (gCreator == gOwner)
        message += "Channel : Set Channel, Current Channel: " + (string)gRezzerNumber + "\n";
    
    message += "Chat     : Rezzer Comms in open chat is ";
    if (llList2String(gMenuList, gChatLoc) == gChatOn)
        message += "on\n";
    else
        message += "off\n";
    
    message += "Pos       : Set Building Position. Set to ";
    if (llList2String(gMenuList, gPosLoc) == gPosRez)
        message += "rezzer box\n";
    else
        message += "sim location\n";
    
    if (gCreator == gOwner)
        message += "UnRecord: Remove Component Locations\n";
    message += "Clean   : Remove all building components\n";
    message += "Reset   : Reset Scripts";
    return message;
}


integer get_desc()
{
    string tempString = llGetObjectDesc();
    gRezzerNumber = (integer)tempString;
    
    if (llStringLength(tempString) < 4)
        return FALSE;

    list tempList = llParseString2List(tempString, ["#"], []);
    gRezzerOffset = (vector)llList2String(tempList, 1);
    gRezzerRotation = (rotation)llList2String(tempList, 2);
    return TRUE;
}


set_desc()
{
    string tempString = llGetObjectDesc(); 
    if (llStringLength(tempString) < 10)
        llSetObjectDesc((string)gRezzerNumber);
    else
    {
        list tempList = llParseString2List(tempString, ["#"], []);
        gRezzerOffset = (vector)llList2String(tempList, 1);
        gRezzerRotation = (rotation)llList2String(tempList, 2);
        llSetObjectDesc((string)gRezzerNumber + "#" + (string)gRezzerOffset + "#" + (string)gRezzerRotation);
    }
}

        
integer move_rezzor()
{
    if (get_desc() == TRUE)
    {
        vector currentPos = llGetPos();
        rotation currentRotation = llGetRot();
        vector destPos = (gRezzerOffset * currentRotation) + currentPos;
        rotation destRot = gRezzerRotation * currentRotation;
        
        list params = [];
        integer iHops = llAbs((integer)llCeil(llVecDist(llGetPos(), destPos) / 10.0));
        integer x;
        for( x = 0; x < iHops; x++ ) 
            params += [PRIM_POSITION, destPos];
        llSetPrimitiveParams(params);
        llSetRot(destRot);
        return TRUE;
    }
    
    llOwnerSay("WARNING: Rezzer Position has not been recorded?");
    return FALSE;
}


integer set_channal()
{
    gMenuChannel = (integer)llFrand(-1000000) - 100000; 
    llListenRemove(gListenId);
    gListenId = llListen(gMenuChannel, "", NULL_KEY, "");
    return gMenuChannel;
}


set_RComm_channel()
{
    gRCommChannel = REZZER_CHANNEL + gStartParam * 100 + gRezzerNumber;
    llListenRemove(gRCommId);
    gRCommId = llListen(gRCommChannel, "", NULL_KEY, "");
}


set_VComm_channel()
{
    gVCommChannel = VENDOR_CHANNEL + gVendorNumber * 100;
    llListenRemove(gVCommId);
    gVCommId = llListen(gVCommChannel, "", NULL_KEY, "");
}


default 
{
    on_rez(integer start_param)
    {
        llResetScript();
    }
    
    state_entry()
    {
        gCreator = llGetCreator();
        gOwner = llGetOwner();
        gStartParam = 0;
        gVendorNumber = 0;
        gChannelList = ["+10", "-10", gExit, "+5", "-5", gBack, "+1", "-1"];
        gCreatorList = [gGroupOn, gPosRez, gReset, gFinish, gChatOn, gClean, gBuild, gChannel, gUnRecord, gRecord];
        gOwnerList = [gGroupOn, gPosRez, gReset, gFinish, gChatOn, gClean, gBuild];
        gGroupLoc = llListFindList(gCreatorList, [gGroupOn]);
        gChatLoc = llListFindList(gCreatorList, [gChatOn]);
        gPosLoc = llListFindList(gCreatorList, [gPosRez]);
        
        gRezzerNumber = (integer)llGetObjectDesc();
        if (gRezzerNumber == 0)
        {
            gRezzerNumber = 1;
            llSetObjectDesc((string)gRezzerNumber);
        }
        
        gRCommChannel = REZZER_CHANNEL + gRezzerNumber;
        if (gCreator == gOwner)
            gMenuList = gCreatorList;
        else
            gMenuList = gOwnerList;
        state running;
    }
}
        

state running
{
    on_rez(integer start_param)
    {
        gStartParam = start_param;
        gOwner = llGetOwner();
        
        if (gOwner != gCreator)
            llResetScript();

        if (start_param > 0) // multi-vendor is calling this script
        {
            llSetTimerEvent(0.0);
            gVendorNumber = start_param;
            set_RComm_channel();
            set_VComm_channel();
            if (move_rezzor() == TRUE)
            {
                gIndex = llGetInventoryNumber(INVENTORY_OBJECT) - 1;
                llRezObject(llGetInventoryName(INVENTORY_OBJECT, gIndex), llGetPos(), ZERO_VECTOR, llGetRot(), gStartParam * 100 + gRezzerNumber);
            }
        }
    }
    
    state_entry()
    {
        if (gOwner == gCreator)
            set_VComm_channel();
    }
        
    touch_start(integer total_number)
    {
        if (gStartParam == 0)
        {
            gAvaKey = llDetectedKey(0);
            if (gAvaKey == gOwner || (llList2String(gMenuList, gGroupLoc) == gGroupOn && llSameGroup(gAvaKey)))        
                llDialog(gAvaKey, set_menu_string(), gMenuList, set_channal());  
        }
    }
    
    changed(integer change)
    {
        if(change & CHANGED_OWNER)
        {
            llSetObjectDesc(" ");
            llResetScript();
        }
    }

    listen(integer channel, string name, key id, string message)
    {   
        if(channel == gRCommChannel)
        {
            if( message == "READYTOPOS")
            {   
                vector vThisPos = llGetPos();
                rotation rThisRot = llGetRot();
                llRegionSay(gRCommChannel, "MOVESINGLE|" + llDumpList2String([ vThisPos, rThisRot ], "|"));
            }
            else 
            if( message == "ATDEST")
            {
                gIndex--;
                if(gIndex >= 0)
                {
                    llSleep(REZ_DELAY);
                    llRezObject(llGetInventoryName(INVENTORY_OBJECT, gIndex), llGetPos(), ZERO_VECTOR, llGetRot(), gStartParam * 100 + gRezzerNumber);
                }
                else
                {
                    llSetTimerEvent(TIMER_RATE);
                }
            }
        }
        else
        if (channel == gVCommChannel)
        {
            if (message == "CleanRezzer")
            {
                llRegionSay(gRCommChannel, "CLEAN");
                llDie();
            }
            else
            {
                list temp = llParseString2List(message, ["|"], []);
                string command = llList2String(temp, 0);
                if (command == "RecordRezzer")  // Format: "RecordRezzer|Vendor number|offset|rotation"
                {
                    gVendorNumber = (integer)llList2String(temp, 1);
                    set_VComm_channel();
                    vector baseLocation = (vector)llList2String(temp,2);
                    rotation baseRotation = (rotation)llList2String(temp,3);
                    gRezzerOffset = (llGetPos() - baseLocation) / baseRotation;
                    gRezzerRotation = llGetRot() / baseRotation;
                    llSetObjectDesc((string)gVendorNumber + "#" + (string)gRezzerOffset + "#" + (string)gRezzerRotation);
                    llOwnerSay("Recorded Rezzer Box Position.");
                }
            }
        }
        else
        if (channel == gMenuChannel)
        {
            if (message == gRecord)
            {
                give_message(id, "Recording Positions");
                if(llList2String(gMenuList, gPosLoc) == gPosSim)
                    llRegionSay(gRCommChannel, "RECORDSIM");
                else
                    llRegionSay(gRCommChannel, "RECORD|" + llDumpList2String([ llGetPos(), llGetRot() ], "|"));
            }
            else
            if (message == gBuild)
            {
                give_message(id, "Rezzing the Building!");
                llSetTimerEvent(0.0);
                set_RComm_channel();
                gIndex = llGetInventoryNumber(INVENTORY_OBJECT) - 1;
                llRezObject(llGetInventoryName(INVENTORY_OBJECT, gIndex), llGetPos(), ZERO_VECTOR, llGetRot(), gRezzerNumber);
            }
            else
            if (message == gFinish)
            {
                give_message(id, "Removing component rezzer scripts.");
                llSetTimerEvent(0.0);
                llRegionSay(gRCommChannel, "FINISHED");
            }
            else
            if (message == gGroupOn)
            {
                gMenuList = llListReplaceList(gMenuList, [gGroupOff], gGroupLoc, gGroupLoc);
                llDialog(id, set_menu_string(), gMenuList, channel);  
            }
            else
            if (message == gGroupOff)
            {
                gMenuList = llListReplaceList(gMenuList, [gGroupOn], gGroupLoc, gGroupLoc);
                llDialog(id, set_menu_string(), gMenuList, channel);  
            }
            else
            if (message == gChannel)
                llDialog(id, "Set Comm. Channel\nCurrent Channel: " + (string)gRezzerNumber, gChannelList, channel);
            else 
            if (message == "+1" || message == "+5" || message == "+10" || message == "-1" || message == "-5" || message == "-10")
            {
                if (gRezzerNumber + (integer)message > MAX_CHANNEL)
                    llOwnerSay("Channel can not be more than: " + (string)MAX_CHANNEL);
                else
                if (gRezzerNumber + (integer)message < MIN_CHANNEL)
                    llOwnerSay("Channel can not be less than: " + (string)MIN_CHANNEL);
                else
                {
                    gRezzerNumber += (integer)message;
                    set_RComm_channel();
                    llRegionSay(gRCommChannel, "CHANNEL|" + (string)gRezzerNumber);
                    set_desc();
                }
                llDialog(id,"Set Channel\nCurrent Channel: " + (string)gRezzerNumber, gChannelList, channel);
            }
            else
            if (message == gChatOn)
            {
                gMenuList = llListReplaceList(gMenuList, [gChatOff], gChatLoc, gChatLoc);
                llDialog(id, set_menu_string(), gMenuList, channel);   
            }
            else
            if (message == gChatOff)
            {
                gMenuList = llListReplaceList(gMenuList, [gChatOn], gChatLoc, gChatLoc);
                llDialog(id, set_menu_string(), gMenuList, channel); 
            }
            else
            if (message == gPosSim)
            {
                gMenuList = llListReplaceList(gMenuList, [gPosRez], gPosLoc, gPosLoc);
                llDialog(id, set_menu_string(), gMenuList, channel); 
            }
            else
            if (message == gPosRez)
            {
                gMenuList = llListReplaceList(gMenuList, [gPosSim], gPosLoc, gPosLoc);
                llDialog(id, set_menu_string(), gMenuList, channel); 
            }
            else
            if (message == gUnRecord)
            {
                give_message(id, "Unrecording Positions");
                llSetTimerEvent(0.0);
                llRegionSay(gRCommChannel, "UNRECORD");
            }
            else
            if (message == gReset)
            {
                give_message(id, "Reset Script");
                llResetScript();
            }
            else
            if (message == gClean)
            {
                give_message(id, "Removing components");
                llSetTimerEvent(0.0);
                llRegionSay(gRCommChannel, "CLEAN");
            }
            else
            if (message == gBack)
                llDialog(id, set_menu_string(), gMenuList, channel);
        } 
    }
    
    timer()
    {
        if((llGetRot() != gLastRot) || (llGetPos() != gLastPos))
        {
            gLastPos = llGetPos();
            gLastRot = llGetRot();
            llRegionSay(gRCommChannel, "MOVE|" + llDumpList2String([ gLastPos, gLastRot ], "|"));
        }
    }
}