integer indexDestination;        // index to where we are heading
integer iRunning;            // flag that indicates we are running, or stopped.
integer iSwimCounter = 0;        // a state machine counter
string  FWD_DIRECTION   = "-y";    // the whale swims in the Y direction
float INTERVAL = 0.2;        // How often we move
vector vDestination;        // the next destination we swim towar
float DAMPING = 0.2;               // point to the new destinatin in this number of seconds

list coords = [
<216,197,20>,
<167,185,20>,
<150,181,20>,
<180,84,20>,
<179,74,20>,
<199,64,20>,
<214,64,20>,
<221,12,20>,
<212,166,20>
];


float calc (float i)
{
    return llSin((i-20)*40 / PI) * 4;    
}

default
{
    on_rez(integer p)
    {
        llResetScript();
    }

    state_entry()
    {
        indexDestination = 0;                // point to the first coordinate
        vDestination = llList2Vector(coords,indexDestination); // get the first destination
        llSetStatus(STATUS_PHYSICS, FALSE);        // make the whale into a prim
        // llSetStatus(STATUS_PHANTOM, TRUE);        // make it phantom so the sculpt's boundary box is smaller
        llMessageLinked(LINK_SET,0,"off",NULL_KEY);    // tell any other scripts in other prims that we are 'off'
        // llSetAlpha( 1.0, ALL_SIDES);            // make the box visible.
    }


    touch_start(integer p)
    {
        if (llDetectedKey(0) == llGetOwner())
        {
            if (iRunning)
            {
                llOwnerSay("whale is stopped");
                iRunning = FALSE;
//              llSetAlpha( 1.0, ALL_SIDES);
                llSetStatus(STATUS_PHYSICS, FALSE);
                llMessageLinked(LINK_SET,0,"off",NULL_KEY);   // make the scripts run
                llSetTimerEvent(0.0);
                llSetStatus(STATUS_PHYSICS, FALSE);
            }
            else
            {
                llOwnerSay("whale is  running");
     
//              llSetAlpha( 0.0, ALL_SIDES);
                iRunning = TRUE;
                llSetTimerEvent(INTERVAL);            // start the timer
                llSetStatus(STATUS_PHYSICS, TRUE);
                llMessageLinked(LINK_SET,0,"on",NULL_KEY);    // make the root prim invisible
                llSetStatus(STATUS_PHYSICS, TRUE);
            }
        }
    }

    timer()
    {
        // Go 2 meters from  the current point, towards the destination
        // with the timer at 0.2 second, we will travel 10 meters a second
        vector newdest = (llVecNorm(vDestination - llGetPos()) * 2) + llGetPos();
        llLookAt(newdest, 0.05, 3.0); // look at the new destination in 1 second.

        float dist = llVecDist(vDestination,llGetPos());        // see how close we are to the destination
        if (dist > 1.0)
        {
            llMoveToTarget(newdest, DAMPING);            // get +there in .2 seconds
        }
        else
        {
            indexDestination++;            // look at next destination
            if (indexDestination >=  llGetListLength(coords))
                indexDestination = 0;    // start at the beginning if we run off the end
            vDestination = llList2Vector(coords,indexDestination);    
            //vDestination.z += 10;  // move 10 meters upwards    (uncomment for debugging)
        }
        // iSwimCounter++;
    }
}