// Script Name: Easy_Animal_Animator_script_for_multiple_prims.lsl
//You should use the single prim script now. This script is for historical purposes.
//
//See http://www.free-lsl-scripts.com/freescripts.plx?ID=1519
//
//These two scripts use the new llSetPrimitiveParamsFast() command to make smooth muti-prim animals walk, move arms and legs, or do any other multiple child prim motion simple.    You can animate any linked object without any 0.2 second delays.   

// Downloaded from : http://www.free-lsl-scripts.com/cgi/freescripts.plx?ID=1445

// This program is free software; you can redistribute it and/or modify it.
// Additional Licenes may apply that prevent you from selling this code
// and these licenses may require you to publish any changes you make on request.
//
// There are literally thousands of hours of work in these scripts. Please respect
// the creators wishes and follow their license requirements.
//
// Any License information included herein must be included in any script you give out or use.
// Licenses are included in the script or comments by the original author, in which case
// the authors license must be followed.

// A GNU license, if attached by the author, means the original code must be FREE.
// Modifications can be made and products sold with the scripts in them.
// You cannot attach a license to make this GNU License 
// more or less restrictive.  see http://www.gnu.org/copyleft/gpl.html

// Creative Commons licenses apply to all scripts from the Second Life
// wiki and script library and are Copyrighted by Linden Lab. See
// http://creativecommons.org/licenses/

// Please leave any author credits and headers intact in any script you use or publish.
// If you don't like these restrictions, then don't use these scripts.
//////////////////////// ORIGINAL AUTHORS CODE BEGINS ////////////////////////////////////////////
// Open source, GPL license.
// Do not remove the header, do not sell this script.
// ______           _  ______            _           _
// |  ___|         | | |  ___|          | |         (_)
// | |_ ___ _ __ __| | | |_ _ __ ___  __| | ___ _ __ ___  __
// |  _/ _ \ '__/ _` | |  _| '__/ _ \/ _` |/ _ \ '__| \ \/ /
// | ||  __/ | | (_| | | | | | |  __/ (_| |  __/ |  | |>  <
// \_| \___|_|  \__,_| \_| |_|  \___|\__,_|\___|_|  |_/_/\_\
//
// author Ferd Frederix

// Prim positioner child script.
// Put a copy of this script in any prim you wish to move

integer debug = 0;
integer linkchannel = 5001;         // for recording purposes
vector vLastpos;
rotation rLastrot;

default
{
    on_rez(integer p)
    {
        llResetScript();
    }

    // accept messages from the main script
    link_message(integer sender_num, integer num, string msg, key id)
    {
        if (msg == "Set")  // SEt records the current prim rot and pos.
        {
            llSleep(llFrand(3.0));
            vector vPos = llGetLocalPos();
            rotation rRot = llGetLocalRot();

            if (vPos != vLastpos || rRot != rLastrot)
                llMessageLinked(LINK_ROOT, linkchannel, (string) vPos + "|" + (string) rRot, "");

            vLastpos = vPos;
            rLastrot = rRot;
        }
        else if (msg == "Remove")        // deletes the script from the child to help with lag
        {
            if (debug)
                llSetScriptState(llGetScriptName(),FALSE);
            else
                llRemoveInventory(llGetScriptName());
        }
        else if (msg == "Reset")        // set the coords to some rare value so the prim will have been seen to have moved
        {
            vLastpos = <0,0,0>;
            rLastrot = <0,0,0,1>;
        }
        else if (msg == "All")    // dump the current pos and rot to the server
        {
            vector vPos = llGetLocalPos();
            rotation rRot = llGetLocalRot();
            llSleep(llFrand(3.0));
            llMessageLinked(LINK_ROOT, linkchannel, (string) vPos + "|" + (string) rRot, "");
        }
    }
}


