// Jellyfish swimming script.
// Justin K. Reeve - 2012-02-27
// This is still a rough script that needs some work. Ideally, we shouldn't hard-code the original position, but for some reason OpenSim isn't handling realignment to the original position well.

float dx;
float dy;
float dz;
vector originalPos = <188,26,5>;
float maxDistance = 5;
float distance;

default
{
    on_rez()
    {
        llResetScript();
    }

    changed(integer change)
    {
        if (change & CHANGED_REGION_START) //note that it's & and not &&... it's bitwise!
        {
            llResetScript();
        }
    }

    state_entry()
    {
        llSetPos(originalPos);
        dx = llFrand(2) + 0.5;
        dy = llFrand(2) + 0.5;
        dz = 0;
        integer abs1 = (integer) llFrand(2);
        integer abs2 = (integer) llFrand(2);
        if (abs1 == 1)
            dx = dx * -1;
        if (abs2 == 1)
            dy = dy * -1;
        llSetStatus(STATUS_PHYSICS, TRUE);
        llSetBuoyancy(1.0);
        llSetPos(originalPos);
        llSetTimerEvent(1.5);
    }

    timer()
    {
        integer counter;    // If the jellyfish doesn't find a random direction to go after 20 iterations, return it to its original position.
        vector nextPos = llGetPos();    // Remain stationary as default.
        do
        {
            nextPos = llGetPos() + <dx, dy, dz>;

            // Calculate the distance between the points (D = Sqrt(dx^2 + dy^2)).
            distance = llSqrt(llPow((originalPos.x - nextPos.x), 2) + llPow((originalPos.y - nextPos.y), 2)); 
            if (distance > maxDistance)
            {
                dx = llFrand(2) + 0.5;
                dy = llFrand(2) + 0.5;
                dz = 0;
                integer abs1 = (integer) llFrand(2);
                integer abs2 = (integer) llFrand(2);
                if (abs1 == 1)
                    dx = dx * -1;
                if (abs2 == 1)
                    dy = dy * -1;
            }

            counter++;
            if (counter > 20)
            {
                llSetPos(originalPos);
                break;
            }
        }
        while (distance > maxDistance);
        // llSay(0, "Moving from " + (string) llGetPos() + " to " + (string) nextPos + ". " + (string) distance + " meters away from origin.");
        llMoveToTarget(nextPos, 0.5);
        llSetRot(llEuler2Rot(<0,0,0>));
    }
}