// script made from a freely available script

float timeout = 60.0; // time out for menu
integer pin = 379642536;

integer chatChannel;
string  menuText = "Choose context of change.";
integer listenHandle;

float localRescale = 1;

default
{
    state_entry()
    {
        llSetRemoteScriptAccessPin(pin);
    }

    changed (integer change)
    {
        if (change & CHANGED_OWNER)
        {
            localRescale = 1;
        }
    }

    link_message(integer source, integer num, string message, key id)
    {
        if (num == 124 && message == "DELETE")
        {
            llRemoveInventory(llGetScriptName());
            return;
        }

        if (num != 123 && num != 125)
        {
            return;
        }

        float scale = (float)message;
        vector tempVec = llGetScale();
        tempVec *= scale;
        llSetScale(tempVec);
        if (llGetLinkNumber() > 1)
        {
            vector tempPos = llGetLocalPos();
            tempPos *= scale;
            llSetPos(tempPos);
        }

        if (num == 125)
        {
            float tempPos = 1 / localRescale;
            llSetScale((llGetScale() * tempPos));
            localRescale = 1;
        }
    }

    timer()
    {
        llOwnerSay("Dialog expired. If needed, touch the prim again for a new dialog.");
        llSetTimerEvent(0);
        llListenRemove(listenHandle);
        listenHandle = FALSE;
    }

    touch_start(integer num)
    {
        if (llDetectedKey(0) != llGetOwner())
        {
            return;
        }

        if (!listenHandle)
        {
            chatChannel  = llRound(llFrand(10000000)) + 10;
            listenHandle = llListen(chatChannel, "", NULL_KEY, "");
            llSetTimerEvent(timeout);
        }

        llDialog(llGetOwner(), menuText, ["This Prim", "All Prims"], chatChannel);

    }

    listen(integer channel, string name, key id, string message)
    {
        if (id != llGetOwner())
        {
            return;
        }

        llSetTimerEvent(timeout); // Reset the timer.

        if (message == "All Prims")
        {
            llMessageLinked(LINK_SET, 900, "MENU", NULL_KEY);
        }

        if (message == "This Prim")
        {
            llDialog(llGetOwner(), "Prim change menu", ["Scale +1%", "Scale -1%", "Revert"], chatChannel);
        }

        if (message == "Scale +1%")
        {
            localRescale *= 1.01;
            llSetScale((llGetScale() * 1.01));
            if (llGetLinkNumber() > 1)
            {
                vector tempPos = llGetLocalPos();
                tempPos *= 1.01;
                llSetPos(tempPos);
            }
            llDialog(llGetOwner(), "Prim change menu", ["Scale +1%", "Scale -1%", "Revert"], chatChannel);
        }

        if (message == "Scale -1%")
        {
            localRescale *= 0.99;
            llSetScale((llGetScale() * 0.99));
            if (llGetLinkNumber() > 1)
            {
                vector tempPos = llGetLocalPos();
                tempPos *= 0.99;
                llSetPos(tempPos);
            }
            llDialog(llGetOwner(), "Prim change menu", ["Scale +1%", "Scale -1%", "Revert"], chatChannel);
        }

        if (message == "Revert")
        {
            float tempPos = 1 / localRescale;
            llSetScale((llGetScale() * tempPos));
            localRescale = 1;
            llDialog(llGetOwner(), "Prim change menu", ["Scale +1%", "Scale -1%", "Revert"], chatChannel);
        }
    }
}