// Copyright 2011 Michael Bailey (Marcus Llewellyn). All rights reserved.
// This script distributed under the Simplified BSD License. A copy of
// this license should be included with this script.

//
// For this script to work, your simulator MUST have the NPC module enabled.
// In addition, some functions MUST be enabled in your simulators OpenSim.ini
// file for this script to work. These functions are:
//      osNpcCreate
//      osNpcRemove
//      osNpcSit
//

string npccard = "";
integer timer_interval = 60;
key npcID = NULL_KEY;
vector npcposition = <0.0,0.0,0.0>;
key sittarget = NULL_KEY;
integer link_sign = 0;
integer link_button = 0;
integer link_base = 0;
integer link_posestand = 0;

string FindAppearance() {
    // Look for and return the name of the NPC appearance notecard.
    integer inventorysize = llGetInventoryNumber(INVENTORY_NOTECARD);
    integer i = 0;
    for (i=0;i<inventorysize;i++) {
        string name = llGetInventoryName(INVENTORY_NOTECARD, i);
        if (name != "LICENSE" && name != "INSTRUCTIONS" && name != "Creative Commons Attribution-ShareAlike 3.0 Unported") { return name; }
    }
    return "";
}

ShowSign() {
    // Look for and display the sign texture.
    integer inventorysize = llGetInventoryNumber(INVENTORY_TEXTURE);
    if (inventorysize == 0) {
        llSay(0, "Unable to find the texture for the sign! Please alert the owner.");
        return;
    }
    integer i = 0;
    for (i=0;i<inventorysize;i++) {
        string name = llGetInventoryName(INVENTORY_TEXTURE, i);
        llSetLinkTexture(link_sign, name, 1);
        llSay(0, "Found a sign texture named: " + name);
    }
}

GiveOutfit(key target, string folder) {
    // Give the outfit items to the visitor in a folder.
    list items = [];
    integer i = 0;
    integer loopsize = llGetInventoryNumber(INVENTORY_CLOTHING);
    for (i=0;i<loopsize;i++) {
        items += [llGetInventoryName(INVENTORY_CLOTHING, i)];
    }
    loopsize = llGetInventoryNumber(INVENTORY_BODYPART);
    for (i=0;i<loopsize;i++) {
        items += [llGetInventoryName(INVENTORY_BODYPART, i)];
    }
    loopsize = llGetInventoryNumber(INVENTORY_OBJECT);
    for (i=0;i<loopsize;i++) {
        items += [llGetInventoryName(INVENTORY_OBJECT, i)];
    }
    llGiveInventoryList(target, folder, items);
}

default
{
    state_entry() {
        llSay(0, llGetObjectName() + " is starting up!");
        // Get sit target and link numbers for button and sign.
        integer i = 0;
        integer links = llGetNumberOfPrims() + 1;
        for (i; i<links; i++) {
            string name = llToLower(llGetLinkName(i));
            if (name == "pose stand") {
                link_posestand = i;
                sittarget = llGetLinkKey(i);
            }
            if (name == "sign") { link_sign = i; }
            if (name == "base prim") { link_base = i; }
            if (name == "preview button") { link_button = i; }
        }
        // Kill any lost NPCs.
        osNpcRemove(llList2Key(llGetLinkPrimitiveParams(link_base, [PRIM_DESC]), 0));
        llSetLinkPrimitiveParams(link_base, [PRIM_DESC, (string)NULL_KEY]);
        // Set up the sign texture.
        ShowSign();
        // Setup the NPC appearance.
        npccard = FindAppearance();
        if (npccard != "") {
            llSay(0, "Found the model named: " + npccard);
        } else {
            llSay(0, "Oh no! No model information was found!");
            llSay(0, "No model can be displayed without an appearance notecard. Please alert the owner.");
        }
        llSay(0, llGetObjectName() + " is operational.");
    }
    
    touch_start(integer num) {
        // What got touched?
        integer touched = llDetectedLinkNumber(0);
        // Demo button was touched.
        if (touched == link_button) {
            // Don't rez an NPC if one already exists.
            if (npcID != NULL_KEY) { return; }
            // Take the NPC's name from the name of our appearance card.
            string firstname = llDeleteSubString(npccard, llSubStringIndex(npccard, " "), -1);
            string lastname = llDeleteSubString(npccard, 0, llSubStringIndex(npccard, " ") + llStringLength(" ") - 1);
            // Instantiate the NPC.
            npcposition = llList2Vector(llGetLinkPrimitiveParams(link_posestand, [PRIM_POSITION]), 0);
            npcID = osNpcCreate(firstname, lastname, npcposition, npccard);
            llSetLinkPrimitiveParams(link_base, [PRIM_DESC, (string)npcID]);
            osNpcSit(npcID, sittarget, OS_NPC_SIT_NOW);
            llSetTimerEvent(timer_interval);
            return;
        }
        // Sign was touched.
        if (touched == link_sign) {
            // Give who touched it the outfit.
            GiveOutfit(llDetectedKey(0), npccard);
            //llGiveInventory(llDetectedKey(0), outfit);
            llInstantMessage(llDetectedKey(0), "Thank you! A folder named \"" + npccard + "\" was placed in your inventory.");
            return;
        }
    }
    
    timer() {
        // Remove the NPC.
        if (npcID != NULL_KEY) {
            osNpcRemove(npcID);
            npcID = NULL_KEY;
            llSetLinkPrimitiveParams(link_base, [PRIM_DESC, (string)npcID]);
            llSetTimerEvent(0);
        }
    }
    
    changed(integer change) {
        // Cover our butts.
        if (change & CHANGED_INVENTORY) { llResetScript(); }
        if (change & CHANGED_OWNER) { llResetScript(); }
        if (change & CHANGED_REGION) { llResetScript(); }
    }
}