// Copyright 2011 Michael Bailey (Marcus Llewellyn). All rights reserved.
// This script distributed under the Simplified BSD License. A copy of
// this license should be included with this script.
// modified by Nebadon Izumi 12/11/2011

string itemname = "";
integer link_sign = 0;
integer link_button = 0;
integer link_base = 0;
integer link_posestand = 0;

ShowSign() {
    // Look for and display the sign texture.
    integer inventorysize = llGetInventoryNumber(INVENTORY_TEXTURE);
    if (inventorysize == 0) {
        llSay(0, "Unable to find the texture for the sign! Please alert the owner.");
        return;
    }
    integer i = 0;
    for (i=0;i<inventorysize;i++) {
        string name = llGetInventoryName(INVENTORY_TEXTURE, i);
        llSetLinkTexture(link_sign, name, 1);
        llSay(0, "Found a sign texture named: " + name);
    }
}

GiveOutfit(key target, string folder) {
    // Give the outfit items to the visitor in a folder.
    list items = [];
    integer i = 0;
    integer loopsize = llGetInventoryNumber(INVENTORY_CLOTHING);
    for (i=0;i<loopsize;i++) {
        items += [llGetInventoryName(INVENTORY_CLOTHING, i)];
    }
    loopsize = llGetInventoryNumber(INVENTORY_BODYPART);
    for (i=0;i<loopsize;i++) {
        items += [llGetInventoryName(INVENTORY_BODYPART, i)];
    }
    loopsize = llGetInventoryNumber(INVENTORY_OBJECT);
    for (i=0;i<loopsize;i++) {
        items += [llGetInventoryName(INVENTORY_OBJECT, i)];
    }
    llGiveInventoryList(target, folder, items);
}

default
{
    state_entry() {
        llSay(0, llGetObjectName() + " is starting up!");
        // Get sit target and link numbers for button and sign.
        integer i = 0;
        integer links = llGetNumberOfPrims() + 1;
        for (i; i<links; i++) {
            string name = llToLower(llGetLinkName(i));
            if (name == "sign") { link_sign = i; }
            if (name == "base prim") { link_base = i; }
        }
        // Set up the sign texture.
        ShowSign();
        itemname = llGetObjectName();
        llSay(0, llGetObjectName() + " is operational.");
    }
    
    touch_start(integer num) {
        // What got touched?
        integer touched = llDetectedLinkNumber(0);
        // Sign was touched.
        if (touched == link_sign) {
            // Give who touched it the outfit.
            GiveOutfit(llDetectedKey(0), itemname);
            //llGiveInventory(llDetectedKey(0), outfit);
            llInstantMessage(llDetectedKey(0), "Thank you! A folder named \"" + itemname + "\" was placed in your inventory.");
            return;
        }
    }
    
    changed(integer change) {
        // Cover our butts.
        if (change & CHANGED_INVENTORY) { llResetScript(); }
        if (change & CHANGED_OWNER) { llResetScript(); }
        if (change & CHANGED_REGION) { llResetScript(); }
    }
}