// Copyright (C) 2007 monk zymurgy and thomax g.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 U

integer script;

string dance;
string olddance;

list dance_sequence;
key current_id;
string seq_string;

prepare_dance_seq(string str) {
    dance_sequence = [];
    list dances = llParseString2List(str,[":"],[]);
    integer i;
    for(i = 0; i < llGetListLength(dances); i++) {
        list tmp = llParseString2List(llList2String(dances,i),[";"],[]);
        dance_sequence += [llList2String(tmp,0), llList2String(tmp,1)];
    }
}

manage_dance_seq() {
    float seq_timer;

    if(dance != "" && dance != "STOP")
        olddance = dance;
                
    dance = llList2String(dance_sequence,0);
    seq_timer = (float)llList2String(dance_sequence,1);
    
    if(current_id == llGetPermissionsKey()
    && current_id != NULL_KEY) {
        llStopAnimation(olddance);
        if (dance != "STOP") {
            llStartAnimation(dance);
            llSetTimerEvent(seq_timer);
        }
    } else {
        llRequestPermissions(current_id,PERMISSION_TRIGGER_ANIMATION);
        llSetTimerEvent(seq_timer);
    }
}

default
{
    state_entry()
    {
        dance = "";
        olddance = "";
        list temp = llParseString2List(llGetScriptName(),[" ","-"],[]);
        script = (integer)llList2String(temp,1);
        llOwnerSay("Dancer "+(string)script+" - is ONLINE!");
    }
    
    link_message(integer sender_num, integer num, string str, key id)
    {
        if (num == script)
        {
            if (str == "stop") {
                llSetTimerEvent(0.0);
            }
            else {
                //llOwnerSay("OS Dancer "+(string)script+" Message = "+str+" key = "+(string)id);
                current_id = id;
                seq_string = str;
                prepare_dance_seq(seq_string);
                manage_dance_seq();
            }
        }
    }
    
    timer() {
        dance_sequence = llDeleteSubList(dance_sequence, 0, 1);
        if(llGetListLength(dance_sequence)==0)
            prepare_dance_seq(seq_string);
        manage_dance_seq();
    }
        
    run_time_permissions(integer parm) {
        if(parm == PERMISSION_TRIGGER_ANIMATION) {
            if(olddance != "")
                llStopAnimation(olddance);
            
            if (dance != "STOP" || dance != "") {
                llStartAnimation(dance);
            }
        } else {
            llResetScript();
        }
    } 
}

