default
{
    state_entry()
    {
        llSetTimerEvent(30);
    }
    timer()
    {
         //This variable will be the Z rotation of our hand.
        float rotz;
        
        //These next few lines will get the number of seconds since midnight, round it down to the nearest whole number, and divide it to get the total number of minutes that is, thendivide that for thetotal hours,and get the remaining minutes to use for the hand.
        integer time = llFloor(llGetWallclock());
        integer min = llFloor(time / 60);
        integer hour = llFloor(min / 60);
        min = min - (hour*60);
  
        //Since a circle has 360 degrees, and there are 60 minutes in an hour, each minute will end up being a 6 degree movement.
        rotz = min * 6;

        //Hard stuff here, but the basic gist is that SL does not recognize an XYZ vector as a rotation, it needs to have a euler angle attached to it to, but rather than do the math, can just let SL do it for us.
        vector eul = <0, 0, (-rotz)>;
        eul *= DEG_TO_RAD;
        rotation rot = llEuler2Rot(eul);

        //And finally, this will set the hand to the right local rotation for our hand.
        llSetLocalRot(rot);
    }
}