// center sliding door.lsl
//
// /!\ PUBLIC DOMAIN /!\
// You can Copy/Mod/Trans
// Please, do not resell this script and do give it full perm
//
// History:
//  SabrinaI 2007-08-03  Created from several examples
//
//
string  settingNoteCard = "DoorSettings";

integer AUTO_OPEN   = 0;    // Open the door just before it is hit
float   CLOSE_AFTER = 10;  // seconds until door is closed, 0 == never
float   STEP_SIZE   = .2;   // size of open/close step from 0 to 1
float   STEP_TIME   = .1;   // time betweens door motion steps

integer gLineNo;
float   gPosition;
integer gAllowState = 0;    // 0 == ALLOW_ALL; 1 == ALLOW_SOME; 2 == DISALLOW_ALL; 3 == DISALLOW_SOME
list    gAllowList;

doorPosition(float position)  // 0==closed 1==open
{
  llSetPrimitiveParams([PRIM_TYPE, 0, 0, <0., 1., 0.>, 0.949000,
                <0., 0., 0.>, <position, 1., 0.>, <0., 0., 0.>]);
}

integer allowed(integer numAvs)
{
  integer i;

  if (gAllowState == 0)
    return 1;
  if (gAllowState == 2)
    return 0;
  for (i=0; i < numAvs; i++)
    if (llListFindList(gAllowList, [llToUpper(llDetectedName(i))]) != -1)
      return (gAllowState == 1);
  return (gAllowState != 1);
}

processConfig(string linein)
{
  integer i;
  string  cmd;

  // remove comments
  i = llSubStringIndex(linein, "//");
  if (i != -1)
  {
    if (i > 0)
      linein = llGetSubString(linein, 0, i - 1);
    else
      linein = "";
  }
  linein = llStringTrim(linein, STRING_TRIM); //remove spaces from ends

  // split command word from arguments
  i = llSubStringIndex(linein, " ");
  if (i == -1)
  {
    cmd = linein;
    linein = "";
  }
  else
  {
    cmd    = llGetSubString(linein, 0, i - 1);
    linein = llGetSubString(linein, i+1, -1);
  }
  cmd = llToUpper(cmd);

  if (cmd == "ALLOW")
  {
    string who = llToUpper(llStringTrim(linein, STRING_TRIM));
    if (who == "ALL")
      gAllowState = 0;
    else
    {
      if (gAllowState != 1)
      {
        gAllowState = 1;
        gAllowList = [];
      }
      gAllowList += [who];
    }
  }
  else if (cmd == "AUTO_OPEN")
  {
    AUTO_OPEN = (integer) linein;
  }
  else if (cmd == "CLOSE_AFTER")
  {
    CLOSE_AFTER = (float) linein;
    if (CLOSE_AFTER < 0.0)
      CLOSE_AFTER = 0.0;
  }
  else if (cmd == "DISALLOW")
  {
    string who = llToUpper(llStringTrim(linein, STRING_TRIM));
    if (who == "ALL")
      gAllowState = 2;
    else
    {
      if (gAllowState != 3)
      {
        gAllowState = 3;
        gAllowList = [];
      }
      gAllowList += [who];
    }
  }
  else if (cmd == "STEP_SIZE")
  {
    STEP_SIZE = (float) linein;
    if (STEP_SIZE > 0.5)
      STEP_SIZE = 0.5;
  }
}

default
{
  state_entry()
  {
    gLineNo = 0;
    if (llGetInventoryType(settingNoteCard) == INVENTORY_NOTECARD)
      llGetNotecardLine(settingNoteCard, gLineNo++);   //read first line of notecard
    else
    {
      llOwnerSay("No settings >"+settingNoteCard+"< notecard found");
      state door_closed;
    }
  }
  on_rez(integer start_parm)
  {
    llResetScript();
  }
  changed(integer change)
  {
    llResetScript();
  }

  dataserver(key query_id, string data)
  {
    if (data == EOF)
      state door_closed;

    processConfig(data);
    llGetNotecardLine(settingNoteCard, gLineNo++);   //read next line of notecard
  }

  state_exit()
  {
    llOwnerSay(llGetScriptName()+": "+(string)llGetFreeMemory()+" bytes free");
  }
}

// close door and wait for open event
state door_closed
{
  state_entry()
  {
    llSetTimerEvent(0);
    doorPosition(0.0);
  }
  on_rez(integer start_parm)
  {
    llResetScript();
  }

  touch_start(integer numAvs)
  {
    if (allowed(numAvs))
      state door_open;
    else
      llWhisper(0, "Sorry this door is locked");
  }
  collision_start(integer numAvs)
  {
    if (allowed(numAvs))
      state door_open;
    else
      llWhisper(0, "Sorry this door is locked");
  }
}

// close the door in STEPS then set the door as closed
state door_close
{
  state_entry()
  {
    llSetTimerEvent(STEP_TIME);
    //    llTriggerSound("Door close", 0.8);
    llTriggerSound("44f32d82-8604-1f29-37c9-a35baec646ee", 1.0);
    gPosition = 1.0 - STEP_SIZE;
    doorPosition(gPosition);
  }

  timer()
  {
    gPosition -= STEP_SIZE;
    if (gPosition < 0.0)
      gPosition = 0.0;
    doorPosition(gPosition);
    if (gPosition <= 0.0)
      state door_closed;
  }

  touch_start(integer numAvs)
  {
    if (allowed(numAvs))
      state door_closed;
  }
}

// open the door in STEPs then wait for close
state door_open
{
  state_entry()
  {
    llSetTimerEvent(STEP_TIME);
    //     llTriggerSound("Door open", 0.8);
    llTriggerSound("de7ac1a3-f31b-e1a4-5a21-5b9907921bf1", 1.0);
    gPosition = STEP_SIZE;
    doorPosition(gPosition);
  }

  timer()
  {
    if (gPosition >= 1.0)    // CLOSE_AFTER timer event
      state door_close;

    gPosition += STEP_SIZE;
    if (gPosition >= 1.0)
    {
      gPosition = 1.0;
      llSetTimerEvent(CLOSE_AFTER);  // CLOSE_AFTER == 0.0 will not trigger an event
    }
    doorPosition(gPosition);
  }

  touch_start(integer numAvs)
  {
    if (allowed(numAvs))
      state door_close;
  }
  moving_start()
  {
    state door_close;
  }
}
