// Open Pose Ball
// from Dolyn Foley
// Feel free to ask me about this code
// Please pass it on, a la GPL


string sitAnimation = "";
// if sitAnimation is left blank
// the script will grab the first animation in the container.
// if a value is set, it will use that instead.
//string sitAnimation = "yoga_float";


default {
    on_rez(integer start_param) {
        llResetScript();
    } 

    state_entry() {
        llSitTarget( <0.25,0.0,0.45>, <0.0,0.0,0.0,1.0> );

        // if blank, we look in inventory
        if (sitAnimation == "") {
            sitAnimation = llGetInventoryName(INVENTORY_ANIMATION, 0);
            
            // oops, use default
            if (sitAnimation == "") {
                sitAnimation = "sit";
            }
        }
    }


    // Using state to control sitting
    // If you're in this state, no one is sitting
    changed(integer change) {
        if (change & CHANGED_LINK) {
            key avatar = llAvatarOnSitTarget();
            if ( avatar != NULL_KEY )  {
                llRequestPermissions(avatar,PERMISSION_TRIGGER_ANIMATION);
            }
        }        
    }

        
    run_time_permissions(integer parm) {
        if(parm == PERMISSION_TRIGGER_ANIMATION) {
            llStopAnimation("sit");
            llStartAnimation(sitAnimation);
            state sitting;
        }
    }    
}


state sitting {
    state_entry() {
    }

    // Oddly, this event listener NEEDS to be here.
    // If it isn't, then when you shift out of this state,
    // then event goes dead in default.
    touch_start(integer total_number) {
    }

    // Assume sitting, thus any CHANGED_LINK means standing.        
    changed(integer change) {
        if (change & CHANGED_LINK) {
            llStopAnimation(sitAnimation);
            llResetScript();
        }        
    }

}