// Greeter & Visitor Log 1.0
// Copyright by Snoopy Pfeffer, 2009

// Constants

string  gToolName = "Greeter & Visitor Log 1.0";
string  gObjectName = "Greeter";
string  gCopyright = "Copyright by Snoopy Pfeffer, 2009";
string  CONFIGNC = ".config";

// Default Parameters

string  READMENC = "README";
integer SHOWTEXT = FALSE;
vector  TEXTCOLOR = <0.0,0.0,1.0>;
float   TEXTALPHA = 1.0;

float   RANGE = 40.0;                // meters
float   RATE = 5.0;                  // seconds
integer OWNLANDONLY = TRUE;          // scan own land only?

integer LENGTH = 400;                // maximum length of visitor list
integer CLEARLIST = FALSE;           // clear visitors list after showing?

string  NEWMSG = "Welcome ";         // greeting for new visitors
integer NEWLANDNAME = FALSE;         // include land name?
string  NEWSND = "";                 // sound to play on first visit
string  NEWLM = "Welcome Landmark";  // landmark to give on first visit
string  NEWNC = "Welcome Notecard";  // notecard to give on first visit

string  RETMSG = "Welcome back ";    // greeting for returning visitors
integer RETLANDNAME = FALSE;         // include land name?
string  RETSND = "";                 // sound to play when returned
string  RETLM = "";                  // landmark to give when returned
string  RETNC = "";                  // notecard to give when returned

list    BANNED = [];                 // list of names of banned avatars
string  BANNEDMSG = "You are not allowed here!";  // message banned avatars get
integer EJECTCYCLES = 5;             // eject banned visitor after x cycles

// Global Variables

key     gOwner;
string  gParcelName;       // name of parcel

integer qLine = 0;         // which config line are we on?
key     gUserKey;
integer gChannel;          // channel to communicate with terminal
integer gListenHandle;

list    gRecentVisitors;   // visitors list
list    gGreetedVisitors;  // visitors in range, already greeted
integer gEjectCycle = 0;   // current eject cycle

integer gNumNew = 0;       // number of new visitors
integer gNumReturned = 0;  // number of returned visitors
integer gNumEjected = 0;   // number of ejected visitors

// Help Functions for Notecards

grokConfigLine(string data)
{
    if (llStringLength(data) != 0 && "/" != llGetSubString(data,0,0)) {
        list kvl = llParseString2List(data, ["="], []);
        string tag = llToUpper(llStringTrim(llList2String(kvl,0), STRING_TRIM_TAIL));
        if (tag == "READMENC") {
            READMENC = llStringTrim(llList2String(kvl,1), STRING_TRIM_HEAD);
        } else if (tag == "SHOWTEXT") {
            string sv;
            sv = llToUpper(llStringTrim(llList2String(kvl,1), STRING_TRIM_HEAD));
            if (sv == "TRUE" || sv == "YES") {
                SHOWTEXT = TRUE;
            } else if (sv == "FALSE" || sv == "NO") {
                SHOWTEXT = FALSE;
            } else {
                llOwnerSay("Error: ShowText: TRUE, FALSE, YES or NO");
            }
        } else if (tag == "TEXTCOLOR") {
            list lv = llParseString2List(llList2String(kvl,1), [" "], ["<",">",","]);
            if ((llGetListLength(lv) != 7) || (llList2String(lv,0) != "<") || (llList2String(lv,2) != ",") || (llList2String(lv,4) != ",") || (llList2String(lv,6) != ">")) {
                llOwnerSay("Error: TextColor has to be an RGB color vector (i.e. <0.0,0.0,1.0>)");
            } else {
                TEXTCOLOR = <llList2Float(lv,1), llList2Float(lv,3), llList2Float(lv,5)>;
            }
        } else if (tag == "TEXTALPHA") {
            float fv;
            fv = llList2Float(kvl,1);
            if (fv < 0.0 || fv > 1.0) {
                llOwnerSay("Error: TextAlpha: float between 0.0 and 1.0");
            } else {
                TEXTALPHA = fv;
            }
        } else if (tag == "RANGE") {
            float fv;
            fv = llList2Float(kvl,1);
            if (fv < 1.0 || fv > 255.0) {
                llOwnerSay("Error: Range: float between 1.0 and 255.0 meters");
            } else {
                RANGE = fv;
            }
        } else if (tag == "RATE") {
            float fv;
            fv = llList2Float(kvl,1);
            if (fv < 1.0 || fv > 120.0) {
                llOwnerSay("Error: Rate: float between 1.0 and 120.0 seconds");
            } else {
                RATE = fv;
            }
        } else if (tag == "OWNLANDONLY") {
            string sv;
            sv = llToUpper(llStringTrim(llList2String(kvl,1), STRING_TRIM_HEAD));
            if (sv == "TRUE" || sv == "YES") {
                OWNLANDONLY = TRUE;
            } else if (sv == "FALSE" || sv == "NO") {
                OWNLANDONLY = FALSE;
            } else {
                llOwnerSay("Error: OwnLandOnly: TRUE, FALSE, YES or NO");
            }
        } else if (tag == "LENGTH") {
            integer iv;
            iv = llList2Integer(kvl,1);
            if (iv < 2 || iv > 9999) {
                llOwnerSay("Error: Length: integer between 2 and 9999");
            } else {
                LENGTH = iv;
            }
        } else if (tag == "CLEARLIST") {
            string sv;
            sv = llToUpper(llStringTrim(llList2String(kvl,1), STRING_TRIM_HEAD));
            if (sv == "TRUE" || sv == "YES") {
                CLEARLIST = TRUE;
            } else if (sv == "FALSE" || sv == "NO") {
                CLEARLIST = FALSE;
            } else {
                llOwnerSay("Error: ClearList: TRUE, FALSE, YES or NO");
            }
        } else if (tag == "NEWMSG") {
            NEWMSG = llStringTrim(llList2String(kvl,1), STRING_TRIM_HEAD);
        } else if (tag == "NEWLANDNAME") {
            string sv;
            sv = llToUpper(llStringTrim(llList2String(kvl,1), STRING_TRIM_HEAD));
            if (sv == "TRUE" || sv == "YES") {
                NEWLANDNAME = TRUE;
            } else if (sv == "FALSE" || sv == "NO") {
                NEWLANDNAME = FALSE;
            } else {
                llOwnerSay("Error: NewLandName: TRUE, FALSE, YES or NO");
            }
        } else if (tag == "NEWSND") {
            NEWSND = llStringTrim(llList2String(kvl,1), STRING_TRIM_HEAD);
        } else if (tag == "NEWLM") {
            NEWLM = llStringTrim(llList2String(kvl,1), STRING_TRIM_HEAD);
        } else if (tag == "NEWNC") {
            NEWNC = llStringTrim(llList2String(kvl,1), STRING_TRIM_HEAD);
        } else if (tag == "RETMSG") {
            RETMSG = llStringTrim(llList2String(kvl,1), STRING_TRIM_HEAD);
        } else if (tag == "RETLANDNAME") {
            string sv;
            sv = llToUpper(llStringTrim(llList2String(kvl,1), STRING_TRIM_HEAD));
            if (sv == "TRUE" || sv == "YES") {
                RETLANDNAME = TRUE;
            } else if (sv == "FALSE" || sv == "NO") {
                RETLANDNAME = FALSE;
            } else {
                llOwnerSay("Error: RetLandName: TRUE, FALSE, YES or NO");
            }
        } else if (tag == "RETSND") {
            RETSND = llStringTrim(llList2String(kvl,1), STRING_TRIM_HEAD);
        } else if (tag == "RETLM") {
            RETLM = llStringTrim(llList2String(kvl,1), STRING_TRIM_HEAD);
        } else if (tag == "RETNC") {
            RETNC = llStringTrim(llList2String(kvl,1), STRING_TRIM_HEAD);
        } else if (tag == "BANNED") {
            BANNED = llParseString2List(llStringTrim(llList2String(kvl,1), STRING_TRIM_HEAD), [",", "|"], []);
        } else if (tag == "BANNEDMSG") {
            BANNEDMSG = llStringTrim(llList2String(kvl,1), STRING_TRIM_HEAD);
        } else if (tag == "EJECTCYCLES") {
            integer iv;
            iv = llList2Integer(kvl,1);
            if (iv < 0 || iv > 20) {
                llOwnerSay("Error: EjectCycles: integer between 0 and 20");
            } else {
                EJECTCYCLES = iv;
            }
        } else {
            llOwnerSay("Error: Unknown parameter \"" + tag + "\"");
        }
    }
}

// Startup State

default
{
    on_rez(integer p) {
        llResetScript();
    }
    
    state_entry() {
        gOwner = llGetOwner();
        
        list parcelDetails = llGetParcelDetails(llGetPos(), [PARCEL_DETAILS_NAME]);
        gParcelName = llList2String(parcelDetails, 0);
        
        gRecentVisitors = [];
        gGreetedVisitors = [];
        gEjectCycle = 0;
        
        gNumNew = 0;
        gNumReturned = 0;
        gNumEjected = 0;
        
        if (NEWSND != "") llPreloadSound(NEWSND);
        if (RETSND != "") llPreloadSound(RETSND);
        
        gChannel = 10000 + llFloor(llFrand(10000.0));  // new random channel 10000..19999
        
        llSetObjectName(gToolName);
        llOwnerSay(gCopyright);
        llSetText(gToolName + "\n" + gCopyright, TEXTCOLOR, TEXTALPHA);
        state read_config;
    }
}

// Read Config State

state read_config
{
    on_rez(integer p) {
        llResetScript();
    }
    
    state_entry() {
        llOwnerSay("Reading config from \"" + CONFIGNC + "\"...");
        if (llGetInventoryType(CONFIGNC) != INVENTORY_NOTECARD) {
            llOwnerSay("Error: Config notecard \"" + CONFIGNC + "\" missing");
            state running;
        } else {
            qLine = 0;
            llGetNotecardLine(CONFIGNC, qLine);
        }
    }
    
    dataserver(key requested, string data) {
        if (data == EOF) {
            state running;
        } else {
            data = llStringTrim(data, STRING_TRIM);
            grokConfigLine(data);
            qLine++;
            llGetNotecardLine(CONFIGNC, qLine);
        }
    }
}

// Running State

state running
{
    on_rez(integer p) {
        llResetScript();
    }
    
    state_entry() {
        llSetObjectName(gObjectName);
        llOwnerSay("Ready.");
        
        if (SHOWTEXT) {
            llSetText("Running", TEXTCOLOR, TEXTALPHA);
        } else {
            llSetText("", TEXTCOLOR, TEXTALPHA);
        }
        
        llSensorRepeat("", NULL_KEY, AGENT, RANGE, PI, RATE);
    }
    
    touch_end(integer c) {
        gUserKey = llDetectedKey(0);
        
        if (gUserKey == gOwner) {
            gListenHandle = llListen(gChannel, "", gUserKey, "");
            llDialog(gUserKey, "\nAdministration Functions", ["Statistics", "Disable", "Reset", "Help", "About", "Close", "Visible", "Invisible"], gChannel);
        } else {
            llWhisper(0, "\n" + gToolName + "\n" + gCopyright);
        }
    }
    
    listen(integer channel, string name, key id, string message) {
        if (message == "Close") {
        } else if (message == "About") {
            llOwnerSay("\n" + gToolName + "\n" + gCopyright);
        } else if (message == "Disable") {
            llSensorRemove();
            state disabled;
        } else if (message == "Reset") {
            llResetScript();
        } else if (message == "Statistics") {
            integer i;
            integer len = llGetListLength(gRecentVisitors);
            
            llOwnerSay("Visitor List:");
            for (i=0; i < len; i++) {
                llOwnerSay(llList2String(gRecentVisitors,i));
            }
            
            llOwnerSay("Visitor list length: " + (string)len);
            llOwnerSay("New Visitors: " + (string)gNumNew);
            llOwnerSay("Returned Visitors: " + (string)gNumReturned);
            llOwnerSay("Ejected Visitors: " + (string)gNumEjected);
            llOwnerSay("Free Memory: " + (string)llGetFreeMemory());
            
            if (CLEARLIST) {
                gRecentVisitors = [];
                gGreetedVisitors = [];
                gEjectCycle = 0;
                
                gNumNew = 0;
                gNumReturned = 0;
                gNumEjected = 0;
            }
        } else if (message == "Help") {
            llGiveInventory(gUserKey, READMENC);
        } else if (message == "Visible") {
            llSetAlpha(1.0, ALL_SIDES);
            llSetPrimitiveParams([PRIM_PHANTOM, FALSE]);
        } else if (message == "Invisible") {
            llSetAlpha(0.0, ALL_SIDES);
            llSetPrimitiveParams([PRIM_PHANTOM, TRUE]);
        }
        
        llListenRemove(gListenHandle);
    }
    
    sensor(integer total_number)
    {                
        integer i;
        list newGreetedVisitors = [];
        
        for (i=0; i<total_number; i++) {
            key visitorId = llDetectedKey(i);
            
            if (!OWNLANDONLY || llOverMyLand(visitorId)) {
                string visitor = llDetectedName(i);
                // banned avatar?
                integer j = llListFindList(BANNED, [visitor]);
                if ( j != -1 ) {
                    if (OWNLANDONLY || llOverMyLand(visitorId)) {
                        llOwnerSay("Banned avatar " + visitor);
                        if (BANNEDMSG != "")
                            llInstantMessage(visitorId, BANNEDMSG);
                        if (EJECTCYCLES > 0) {
                            gEjectCycle += 1;
                            if (gEjectCycle >= EJECTCYCLES) {
                                llEjectFromLand(visitorId);
                                gNumEjected += 1;
                                gEjectCycle = 0;
                            }
                        }
                    }
                } else {  // greet returning visitor
                     j= llListFindList(gRecentVisitors, [visitor]);
                    if ( j != -1 ) {  // returning visitor
                        j = llListFindList(gGreetedVisitors, [visitor]);
                        if ( j == -1 ) {  // not greeted already
                            if (RETMSG != "") {
                                if (RETLANDNAME) {
                                    llInstantMessage(visitorId, RETMSG + " " + gParcelName + " " + visitor);
                                } else {
                                    llInstantMessage(visitorId, RETMSG + " " + visitor);
                                }
                            }
                            
                            if (RETSND != "")
                                llPlaySound(RETSND, 1.0);
                            if (RETLM != "")
                                llGiveInventory(visitorId, RETLM);
                            if (RETNC != "")
                                llGiveInventory(visitorId, RETNC);
                            
                            gNumReturned += 1;
                        }
                        newGreetedVisitors += visitor;
                    } else {  // greet new visitor
                        if (NEWMSG != "") {
                            if (NEWLANDNAME) {
                                llInstantMessage(visitorId, NEWMSG + " " + gParcelName + " " + visitor);
                            } else {
                                llInstantMessage(visitorId, NEWMSG + " " + visitor);
                            }
                        }
                        
                        gRecentVisitors += visitor;
                        newGreetedVisitors += visitor;
                        
                        if (NEWSND != "")
                            llPlaySound(NEWSND, 1.0);
                        if (NEWLM != "")
                            llGiveInventory(visitorId, NEWLM);
                        if (NEWNC != "")
                            llGiveInventory(visitorId, NEWNC);
                        
                        gNumNew += 1;
                    }
                }
            }
        }
        
        // update greeted visitors list
        gGreetedVisitors = newGreetedVisitors;
        
        if (llGetListLength(gRecentVisitors) > LENGTH) {
            // truncate recent visitors list
            llDeleteSubList(gRecentVisitors, 0, 1);
        }
    }
    
    no_sensor() 
    {
        // no visitors nearby
        gGreetedVisitors = [];
        gEjectCycle = 0;
    }
}

// Disabled State

state disabled
{
    on_rez(integer p) {
        llResetScript();
    }
    
    state_entry() {
        llSetObjectName(gToolName);
        llSetText("Disabled", TEXTCOLOR, TEXTALPHA);
    }
    
    touch_end(integer c) {
        if (llDetectedKey(0) == gOwner) {
            state running;
        }
    }
}