default
{
    state_entry()
    {
        //This will make the hand update every 30 seconds. You can make this number higher to reduce lag a little bit in a sim, but no higher than 60, and it would be best not to go lower than 10, as that is unnecessary.
        llSetTimerEvent(30);
    }
    timer()
    {
        float rotz;
        
        //Gets the number of seconds since midnight,and rounds it down
        integer time = llFloor(llGetWallclock());
        
        //Finds the number of minutes fromthe seconds, then the number of hours, and the remaining of the minutes

          integer min = llFloor(time/60);
          integer hour = llFloor(min/60);
          min = min - (hour * 60);
          
          //Since this is a 12 hour clock, we want to drop 12 hours if it is past noon
            if (hour > 12)
            {
                hour = hour - 12;
            }
            
            //This makes the hour hand slowly move along as minutes pass, just as a real clock would do. It will move along 1/6 of the way to the next hour every 10 min.
            if(min < 10)
            {
                rotz = hour * 30;
            }
            else if(min<20)
            {
                rotz = (hour * 30) + 5;
            }
            else if(min < 30)
            {
                rotz = (hour * 30) + 10;
            }
            else if(min < 40)
            {
                rotz = (hour * 30) + 15;
            }
            else if(min < 50)
            {
                rotz = (hour * 30) + 20;
            }
            else if(min < 60)
            {
                rotz = (hour * 30) + 25;
            }
            
            //Boring physics, but the short version is that SL does not recognize an x,y,z set as a rotation, and needs a euler angle with it. But we let SL do this with the following code.
            vector eul = <0,0,(-rotz)>;
            eul *= DEG_TO_RAD;
            rotation rot = llEuler2Rot(eul);
            llSetLocalRot(rot);
    }
}