integer doorSteps = 4;
integer reversed  = FALSE;

rotateDoor(integer Open)
{
    rotation rot = llGetRot();
    rotation delta;
    integer  x;
    
    if (reversed) {Open = !Open;};

    if (Open)
    {
        delta = llEuler2Rot(<0, 0, PI/(doorSteps * 2)>);
    }
    else
    {
        delta = llEuler2Rot(<0, 0, -PI/(doorSteps * 2)>);
    }
    
    for (x = 0; x < doorSteps; x++)
    {
        rot = delta * rot;
        llSetRot(rot);
        llSleep(0.03125/doorSteps);
    }
}

default
{
    state_entry()
    {
        state closed;
    }
}

state closed
{
    
    touch_start(integer total_number)
    {
        llTriggerSound("dooropen", 0.5);
        rotateDoor(TRUE);
        state open;
    }
}

state open
{
    touch_start(integer num)
    {
        rotateDoor(FALSE);
        llTriggerSound("doorslam", 0.5);
        state closed;
    }
}