// Copyright (C) 2007 monk zymurgy and thomax g.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 U

// Default values
list dances = ["Funky"];
integer maxcount = 20;
float diatimeout = 30.0;
 
 
// Globals
integer iNotecardIndex;
integer iNotecardCount;
integer iNoteCardLine;
key kCurrentDataRequest;
string sSettingsNotecard;

string toucher;
key diakey;
integer count;

integer logged;
integer dancerno;

list dancers = [];
list dancing = [];

float srange = 50.0;
float stimer = 20.0;


// sequences from dancecard handling
list dance_names;
list dance_sequences;
key QID_lines;
key QID;
integer line;
string dancecard = "_DANCECARD";
integer num_sequences;
integer current_menu;
integer MENUCHN = 3333;
integer lh;

dance_menu(key user) {
    list menu;
    integer i;
    menu = [];
    

    if(current_menu > 0)
        menu += ["PREV","MAIN"];
    else
        menu += [" ","STOP"];

    if(current_menu*8+8 <num_sequences - 1)
        menu += ["NEXT"];
    else
        menu += [" "];

    for(i=current_menu*8; (i <= current_menu*8+8) && (i <= num_sequences - 1);i++) {
        menu += [llList2String(dance_names,i)];
    }

    llDialog(user, "Please select a dance, or select 'STOP' on 'MAIN' menu to stop dancing.\n(F)=Female / (M)=Male / (U)=Unisex\n\nYou have "+(string)((integer)diatimeout)+" seconds to select an option,", menu, MENUCHN);
}


integer docount() {
    integer countup = 0;
    string text = "";
    integer x;
    
    for (x = 0 ; x < maxcount ; x++ ) {
        if (!(llList2String(dancing,x) == "STOP")) {
            countup++;
        }
    }
        
    llSetText( "Danceball is ONLINE\n"
            +(string)countup
            +"/"+(string)maxcount
            +" people are dancing", <0,.5,0>, 0.9 );
    
    return countup;
}
 
default
{
    on_rez( integer param ) {
        llResetScript();
    }
 
    state_entry() {
        integer x;
 
        QID_lines = llGetNumberOfNotecardLines(dancecard);
        llSetText( "Initializing...", <.5,0,0>, 1.0 );
        
        for (x=0; x<maxcount ; x++)
        {
            dancers = dancers + ["E"];
            dancing = dancing + ["STOP"];
            llMessageLinked(LINK_SET, x , "stop", NULL_KEY);
        }  
        llSetTextureAnim(ANIM_ON | LOOP, ALL_SIDES, 4, 4, 0, 10, 10.0);
    }
 
    dataserver(key kQuery, string sData) {
        if(kQuery == QID_lines) {
            llOwnerSay("Start reading dance sequences..");
            line = 0;
            num_sequences = 0;
            dance_names = [];
            dance_sequences = [];
            QID = llGetNotecardLine(dancecard, line);
        }

        if(kQuery == QID) {
            if(sData != EOF) {
                if(llSubStringIndex(sData,"//") != 0 && llStringLength(sData) > 0) {
                    list split_list = llParseString2List(sData,["="],[]);
                    dance_names += [llList2String(split_list,0)];
                    dance_sequences += [llList2String(split_list,1)];
                    num_sequences++;
                }
                line++;
                QID = llGetNotecardLine(dancecard, line);
            } else {
                llOwnerSay("Sequences read.");
                state waiting;
            }
        } 
    }
}
 
 
// Daneceball Waiting State.....

state waiting {
    state_entry() {
        count = docount();
        llSensorRepeat("", "", AGENT, srange, PI, stimer);
    }
        
    touch_start(integer num) {
        toucher = llKey2Name(llDetectedKey(0));
        diakey = llDetectedKey(0);
        state touched;
    }
    
    sensor(integer num) {
        integer x;
        integer y;
        integer found;
        string dancer;

        for (x=0 ; x < maxcount ; x++) {
            found = FALSE;
            dancer = llList2String(dancers,x);
            for (y = 0 ; y < num ; y++) {
                if (llKey2Name(llDetectedKey(y)) == dancer) {
                    found = TRUE;
                    y = num;
                }
            }
            if (found == FALSE && dancer != "E") {
                llSay(0,dancer+" has left the club.");
                dancing = llListReplaceList(dancing,["STOP"], x , x);
                dancers = llListReplaceList(dancers,["E"], x , x);
                llMessageLinked(LINK_SET, x , "stop", NULL_KEY);
                count = docount();
            }
        }
    }
    no_sensor() {
        integer x;
        for(x=0; x < maxcount ; x++) {
            if(llList2String(dancers,x) != "E") {
                llSay(0,llList2String(dancers,x)+" has left the club.");
                dancing = llListReplaceList(dancing,["STOP"], x , x);
                dancers = llListReplaceList(dancers,["E"], x , x);
                llMessageLinked(LINK_SET, x , "stop", NULL_KEY);
                count = docount();
            }
        }
    }
}

state touched {
    state_entry() {
        llSetText(toucher+" is making a selection..",<0.5,0,0>,1.0);

        integer x;
        logged = FALSE;

        current_menu = 0;        
        if (count > 0) {

            for (x=0 ; x<maxcount ; x++) {
                if (toucher == llList2String(dancers,x)) {
                    logged = TRUE;
                    dancerno = x;

                    dance_menu(diakey);
                    lh = llListen(MENUCHN,"",toucher,"");
                    x = maxcount;
                    llSetTimerEvent(diatimeout);
                }
            }
            
            if (!logged) {
                if (count < maxcount) {
                    dance_menu(diakey);
                    lh = llListen(MENUCHN,"",toucher,"");
                    llSetTimerEvent(diatimeout);
                } else {
                    llInstantMessage(toucher,"Sorry "+llKey2Name(toucher)+", the Danceball is full.");
                    state waiting;
                }
            }
        } else {
            dance_menu(diakey);
            lh = llListen(MENUCHN,"",toucher,"");
            llSetTimerEvent(diatimeout);
        }
    }
    
    timer()
    {
        if(lh) {
            llListenRemove(lh);
            lh = 0;
        }
        llInstantMessage(diakey,"Sorry "+llKey2Name(toucher)+", your request has timed out.");
        llSetTimerEvent(0.0);
        state waiting;
    }
    
    listen(integer channel, string name, key id, string message) {
        
        if(message == "PREV") {
            current_menu--;
            dance_menu(id);
            return;
        }

        if(message == "NEXT") {
            current_menu++;
            dance_menu(id);
            return;
        }
        if(message == "MAIN") {
            current_menu=0;
            dance_menu(id);
            return;
        }
        if(lh) {
            llListenRemove(lh);
            lh = 0;
        }
        llSetTimerEvent(0.0);

        list newdata;
        integer x;

        if (logged) {
            if(message == "STOP") {
                llMessageLinked(LINK_SET, dancerno , "STOP;0", diakey);
                toucher = "E";
            } else {
                integer n;
                if(message == "RANDOM") {
                    n = (integer)llFrand(llGetListLength(dance_names));
                    if(n == 0)
                        n = 1;
                    message = llList2String(dance_names, n);
                } else {
                    n = llListFindList(dance_names,[message]);
                }
                llMessageLinked(LINK_SET, dancerno , llList2String(dance_sequences,n), diakey);
            }
            newdata = [message];
            dancing = llListReplaceList(dancing,newdata,dancerno,dancerno);
            newdata = [toucher];
            dancers = llListReplaceList(dancers,newdata,dancerno,dancerno);
        } else {
            for (x = 0; x < maxcount; x++) {
                if (llList2String(dancing,x) == "STOP") {
                    if(message == "STOP") {
                        llMessageLinked(LINK_SET, x , "STOP;0", diakey);
                        toucher = "E";
                    } else {
                        integer n;
                        if(message == "RANDOM") {
                            n = (integer)llFrand(llGetListLength(dance_names));
                            if(n == 0)
                                n = 1;
                            message = llList2String(dance_names, n);
                        } else {
                            n = llListFindList(dance_names,[message]);
                        }
                        llMessageLinked(LINK_SET, x , llList2String(dance_sequences,n), diakey);
                    }
                    newdata = [message];
                    dancing = llListReplaceList(dancing,newdata, x , x);
                    newdata = [toucher];
                    dancers = llListReplaceList(dancers,newdata, x , x);
                    x = maxcount;
                }
            }          
        }
        state waiting;
    }
}
