list sounds = [
    "fd5e08a5-d36f-4c55-9ebb-7ada469fb413", // 0
    "8bf289c9-a25e-482e-b187-2d05f3bcdd7b", // 1
    "1a8c2b2f-fa96-4286-a5d0-89c61255d78c", // 2
    "036c0380-5450-4ad3-bdff-0d6fc7f94cd5", // ...
    "08ab9621-ed5a-4c29-b71e-7615f2785d99",
    "368ff3cb-ea60-4730-8da8-27ca8d7fb925",
    "fa3b4054-bfd8-4035-ab16-c243f2d81564",
    "1b8e914f-b939-4cc6-8e72-2b289a5a6ef3",
    "4c627191-549a-48c5-b549-8e5ce78c018d",
    "8d7630bd-a887-4692-a36a-bc939f01af6a",
    "8d7630bd-a887-4692-a36a-bc939f01af6a"  // 10
    ];

integer stalling = FALSE;
//float stall_angle = 0.785398;
//float recover_angle_b = 0.196349; 
//float recover_angle_p = 0.392699;

float inc_linear_vel = 6.0;
float max_linear_vel = 60.0;
float linear_damper = 16.0;
float cruse_speed = 5.0;

float linear_vel_amount = 0.0;
float linear_vel_new = 0.0;

float inc_pitch_vel = 0.2;
float max_pitch_vel = 0.2;
float pitch_decay = 0.5;
float flt_pitch_amount;

float inc_bank_vel = 0.2;
float max_bank_vel = 0.2;
float bank_decay = 0.5;
float flt_bank_amount;

key id_pilot = NULL_KEY;
vector my_pos;
rotation my_rot;
vector euler;
float elapsed_time;
integer link_exhaust_l;
integer link_exhaust_r;

float gravity;

list sitters = [];

float truncate(float val, float range)
{
    if(val > range)
        return range;
    else if(val < -range)
        return -range;
    else
        return val;
}

integer land_state = -1;

set_movement()
{
    elapsed_time = llGetAndResetTime();
    integer landed = my_pos.z - llGround(ZERO_VECTOR) < 0.25;
    if(landed != land_state)
    {
        land_state = landed;
        if(landed)
            llTriggerSound("e9a822f3-89f5-44c0-84e5-33ad0d97171c", 1.0);
    }
    euler = llRot2Euler(ZERO_ROTATION / my_rot);
    if(landed)
    {
        euler.y = euler.y + flt_pitch_amount;
        euler.z = -flt_bank_amount;
        euler.x = euler.x / 0.5;
    }
    else
    {
        euler.y = flt_pitch_amount;
        euler.x = euler.x / PI;
        euler.x = (llPow(50.0, -llFabs(euler.x)) * euler.x);
        euler.z = euler.x / 0.5;
        euler.x = euler.x / 0.5 + flt_bank_amount;
    }
    euler = euler * elapsed_time;
    my_rot = llEuler2Rot(euler) * llGetRootRotation();
    vector my_vel = (<linear_vel_amount * elapsed_time, 0.0, 0.0> * my_rot);
    float planar_vel = truncate(llVecMag(<my_vel.x, my_vel.y, 0.0> / cruse_speed), 1.0);
    vector tilt = llRot2Euler(llGetRot() / ZERO_ROTATION);
    //if(llFabs(tilt.x) > stall_angle || llFabs(tilt.y) > stall_angle)
        //stalling = TRUE;
    //else if((llFabs(tilt.x) < recover_angle_b && llFabs(tilt.y) < recover_angle_p) && stalling)
        //stalling = FALSE;
    if(!landed)
    {
        if(stalling)
            gravity = truncate(gravity + (9.8 * elapsed_time), 55.6);
        else
            gravity = truncate(gravity + (9.8 * elapsed_time), 55.6) * (1.0 - planar_vel);
    }
    else
        gravity = 0.0;
    //llSetText("g: " + (string)gravity + 
              //"\nl: " + (string)landed +
              //"\npv: " + (string)planar_vel +
              //"\nta: " + (string)tilt + 
              //"\nts: " + (string)stalling, <1.0, 1.0, 0.0>, 1.0);
    my_pos = llGetRootPosition() + my_vel - (<0.0, 0.0, gravity> * elapsed_time);
    llSetLinkPrimitiveParamsFast(LINK_THIS, [PRIM_POSITION, my_pos, PRIM_ROTATION, my_rot]);
    linear_vel_amount += (linear_vel_new - linear_vel_amount) / linear_damper;
    flt_pitch_amount *= pitch_decay;
    flt_bank_amount *= bank_decay;
}

toggle(integer num)
{
    llMessageLinked(LINK_ALL_CHILDREN, num, "ENGINES", NULL_KEY);
    if(num)
    {
        llMessageLinked(LINK_ALL_CHILDREN, 0, "SOUND", llList2Key(sounds, 0));
        llResetTime();
        llSetTimerEvent(0.1);
    }
    else
    {
        llMessageLinked(LINK_ALL_CHILDREN, 0, "SOUND", "");
        llSetTimerEvent(0.0);
    }
}

initiate()
{
    llSetTimerEvent(0.0);
    llSetSitText(":P");
    // llSitTarget(<0.484118,0.000000,1.477222>, <0.000000,-0.034899,0.000000,-0.999391>);
    llSetCameraEyeOffset(<0,0,0>);
    llSetCameraAtOffset(<0,0,0>);
    llStopSound();
    llMessageLinked(LINK_ALL_CHILDREN, FALSE, "ENGINES", NULL_KEY);
}

get_control()
{
    llRequestPermissions(id_pilot, PERMISSION_TAKE_CONTROLS);
}

set_vel(float num)
{
    linear_vel_new = truncate(linear_vel_new + num, max_linear_vel);
    integer gear = (integer)((linear_vel_new / max_linear_vel) * 10);
    llRegionSayTo(id_pilot, 0, "Throttle " + (string)gear);
    llMessageLinked(LINK_ALL_CHILDREN, 0, "SOUND", llList2Key(sounds, gear));
}

key get_pilot()
{
    integer index = llGetNumberOfPrims();
    while(llGetAgentSize(llGetLinkKey(index)) != ZERO_VECTOR)
        --index;
    return llGetLinkKey(++index);
}

default
{
    on_rez(integer start_param)
    {
        llResetScript();
    }
    
    state_entry()
    {
        initiate();
    }
    
    touch_start(integer num_detected)
    {
        key id_agent = llDetectedKey(0);
        if(id_agent == id_pilot)
        {
            if(llGetPermissions() & PERMISSION_TAKE_CONTROLS)
            {
                llReleaseControls();
                toggle(FALSE);
            }
            else
            {
                get_control();
            }
        }
    }
    
    changed(integer change)
    {
        if(change & CHANGED_LINK)
        {
            id_pilot = get_pilot();
            if(id_pilot != NULL_KEY)
            {
                get_control();
            }
            else
            {
                llReleaseControls();
                llDie();
                toggle(FALSE);
            }
        }
    }
    
    control(key id, integer levels, integer edges)
    {
        if (levels & 0x0001)
            flt_pitch_amount = truncate(flt_pitch_amount + inc_pitch_vel, max_pitch_vel);
        if (levels & 0x0002)
            flt_pitch_amount = truncate(flt_pitch_amount - inc_pitch_vel, max_pitch_vel);
        if ((levels & 0x0004) || (levels & 0x0100))
            flt_bank_amount = truncate(flt_bank_amount - inc_bank_vel, max_bank_vel);
        if ((levels & 0x0008) || (levels & 0x0200))
            flt_bank_amount = truncate(flt_bank_amount + inc_bank_vel, max_bank_vel);
        if (levels & edges & 0x0010)
            set_vel(inc_linear_vel);
        if (levels &  edges & 0x0020)
            set_vel(-inc_linear_vel);
    }
    
    listen(integer channel, string name, key id, string message)
    {
        list lst_msg = llParseString2List(llToLower(message), [" "], []);
        string cmd = llList2String(lst_msg, 0);
        if(cmd == "snap")
        {
            if(llList2String(lst_msg, 1) == "n")
                llSetRot(llEuler2Rot(<0.0, 0.0, PI_BY_TWO>));
            else if(llList2String(lst_msg, 1) == "e")
                llSetRot(llEuler2Rot(<0.0, 0.0, 0.0>));
            else if(llList2String(lst_msg, 1) == "w")
                llSetRot(llEuler2Rot(<0.0, 0.0, PI_BY_TWO * 2.0>));
            else if(llList2String(lst_msg, 1) == "s")
                llSetRot(llEuler2Rot(<0.0, 0.0, PI_BY_TWO * 3.0>));
        }
    }
    
    run_time_permissions(integer perm)
    {
        if(perm & PERMISSION_TAKE_CONTROLS)
        {
            toggle(TRUE);
            llTakeControls(0x33F, TRUE, FALSE);
            llListen(0, "", id_pilot, "");
            //llRegionSayTo(id_pilot, 0, "Set!");
        }
        else
        {
            llReleaseControls();
            toggle(FALSE);
        }
    }
    
    timer()
    {
        set_movement();
    }
}