// 500, 400, 300, 200, 100, 50, 40, 30, 20, 10, 5

list altitudes = [
    300.0, "99078888-63d3-4d57-ba8c-b873f099ab28",
    200.0, "fde61ad8-af59-45e1-8b34-b0954f9b8b75",
    100.0, "d64d3e5e-5126-4d5a-9a15-e090f1061d5b",
    50.0, "9c47c911-e273-4532-8fe0-dc68eac186e8",
    40.0, "52747660-ba7a-463c-9362-6dee78cb772a",
    35.0, "d286c39b-ec41-4d98-9302-41acb3440a24",
    30.0, "de0ab681-ef05-474f-9077-1dce95139be0",
    20.0, "6b5b50b7-1dc4-4849-8bc2-003c63d85077",
    10.0, "c3330f67-008b-401a-9ffe-9c4dca95b1f1"
    ];

key id_dnt_snk = "e49404d5-262f-4353-826e-9e3edac717eb";
float repeat_interval = 3.0;

integer altitudes_length;
float height_now;
float height_then;
string sound = "";
    
string get_height_between(float a, float b)
{
    integer index = 0;
    for(index = 0; index < altitudes_length; index += 2)
    {
        float height = llList2Float(altitudes, index);
        if((height >= a) && (height <= b))
            return llList2String(altitudes, index + 1);
    }
    return "";
}


default
{
    state_entry()
    {
        altitudes_length = llGetListLength(altitudes);
        llSetTimerEvent(0.5);
    }
    
    timer()
    {
        vector pos_me = llGetPos();
        float ground = llGround(ZERO_VECTOR);
        float water = llWater(ZERO_VECTOR);
        if(ground < water)
            height_now = pos_me.z - water;
        else
            height_now = pos_me.z - ground;
        string call_out = get_height_between(height_now, height_then);
        if(call_out != "")
        {
            llPlaySound(call_out, 1.0);
        }
        if((ground < water) && (llGetTime() >= repeat_interval) && (height_now <= 10.0))
        {
            llResetTime();
            llPlaySound(id_dnt_snk, 1.0);
        }
        height_then = height_now;
    }
}