// ######################################
// Radio for OpenSim, by Fritigern Gothly
// Version 0.12 - Oct 08, 2011
//
// Add your name and date to these
// comments if you alter this script in
// any way.
// If you put this in your own build, 
// make sure to mention BOTH me and you!
// ######################################
 
integer dchannel; // Will be a random number.
key toucher;
string stationcard = "stations"; // Name for the notecard. Change this is you want to use a different name.
integer cardlines;
integer n;
integer i;
list names;
list uris;
list page;
integer pagenum;
 
// ----------------------
// Needed user functions.
// ----------------------
 
initialize()
{
    //Clear the values to prevent problems
    names =[];
    uris=[];
    page = [];
    pagenum=0;
    cardlines=0;
    // Now get all stations (again)
    cardlines = osGetNumberOfNotecardLines(stationcard);
    for(n=0;n<cardlines;++n)
    {
            // Use llStringTrim to get rid of additional spaces around the
            // string. Makes this script a little more forgiving.
        string line = llStringTrim(osGetNotecardLine(stationcard,n), STRING_TRIM);
        if(llGetSubString(line,0,0)=="#" || line == "")
        {
            // Skip comments and empty lines
        } else {
            integer seperator = llSubStringIndex(line, "=");
            uris += [llStringTrim(llGetSubString(line,seperator+1,llStringLength(line)), STRING_TRIM)];
 
                // Make sure that the button names fit on the buttons. Names 
                // can be up to 24 characters (but only a few will show),
                // Doing this will let you put really long station names in
                // the notecard without problems.
            string desc = llStringTrim(llGetSubString(line,0,seperator-1), STRING_TRIM);
            if(llStringLength(desc) >= 23) desc = llGetSubString(desc,0,23);
            names += [desc];
        }
    }
 
 
        // Get all entries from the list of station names and put them in a string
        // in groups of nine, and put them in a new list..
    string btn;
    for(n=0;n<llGetListLength(names);n=n+9)
    {
        for(i=n;i<(n+9);++i) // Get 9 buttons....
        {
            if(n>llGetListLength(names)) return;
            btn += llList2String(names,i)+",";
        }
        page += [btn]; // ...And put them in a list again! (As a string, not as list items!)
        btn="";
    }
    llOwnerSay("Notecard loaded. "+(string)llGetListLength(names)+" stations in "+llGetListLength(page)+" pages.");
}
 
 
dialog(string buttons)
{
    list b = ["< Prev","Cancel","Next >"]+llParseString2List(buttons,",","");
    string txt = "\nShowing stations "+(string)((pagenum*9)+1)+" to "+(string)((pagenum*9)+llGetListLength(llParseString2List(buttons,",","")))+
                 " of "+(string)llGetListLength(names)+" loaded.\n"+
                 "\nPage "+(string)(pagenum+1)+" of "+(string)llGetListLength(page);
    llDialog(toucher, txt+"\nChoose a station:", b, dchannel);
    b=[]; // Clear the list, and save some memory.
}
 
default
{
    state_entry()
    {
        dchannel = llFloor(llFrand(9999999)); // Choose a random channel.
        initialize();
        if(llGetObjectDesc() != (integer)llGetObjectDesc()||llGetObjectDesc() == "")
        {
            llSetText("OpenSimulator Radio\nClick to choose a station", <1,1,1>,1);
        } else {
            integer index = (integer)llGetObjectDesc();
            llSetText(llList2String(names,index),<1,1,0>,1);
            llSetParcelMusicURL(llList2String(uris,index)); // Sometimes the parcel's audio settings don't survive a restart or server upgrade. So we'll set it again, just to make sure.
        }
        // llOwnerSay("Ready");
    }
 
    touch_start(integer numdet)
    {
        toucher = llDetectedKey(0);
        llListen(dchannel, "","","");
        dialog(llList2String(page,pagenum));
 
    }
 
    listen(integer channel, string name, key id, string msg)
    {
        if(msg == "< Prev")
        {
            --pagenum;
            if(pagenum<0) pagenum = llGetListLength(page)-1;
            dialog(llList2String(page,pagenum));
        } 
        else if(msg == "Next >")
        {
            ++pagenum;
            if(pagenum>=llGetListLength(page)) pagenum = 0;
            dialog(llList2String(page,pagenum));
        } 
        else if(msg == "Cancel")
        {
            pagenum = 0;
            return;
        } 
        else {
                // If none of the predefined buttons were clicked, it must be a station name.
            integer index = llListFindList(names,msg);
            llSetParcelMusicURL(llList2String(uris,index));
            llSay(0,"Station changed to "+llList2String(names,index)+" ("+llList2String(uris,index)+")");
            llSetText(llList2String(names,index),<1,1,0>,1);
            llSetObjectDesc((string)index);
        }
    }
 
    changed(integer ischanged)
    {
            //If something changed in the inventory, go and read the list with stations again!
        if(ischanged & CHANGED_INVENTORY) initialize();
    }
}