// Multiple-joint limb animation script
//
// Author: Jesrad Seraph
// Modify and redistribute freely as long as you permit free modification and redistribution

integer handle;
integer use_euler = FALSE;

list my_limbs = [6, 7];    // the limb number, and numbers of the joints it attaches to, from limb end to body

vector joint;
vector offset;

list animrot;
list animpos;

default
{
    state_entry() { animrot = []; animpos = []; }

    link_message(integer part, integer num, string msg, key id)
    {
        if (msg == "defchan") 
        {
            llListenRemove(handle);
            if (num != 0)
                handle = llListen(num + (integer)llGetSubString(llGetScriptName(), -1, -1), "", "", "");
        } else if (msg == "reset")
        {
            if (animrot != []) llSetPrimitiveParams([PRIM_POSITION, llList2Vector(animpos, 0), PRIM_ROTATION, llList2Rot(animrot, 0) / llGetRootRotation()]);
            animrot = [];
            animpos = [];
            llListenRemove(handle);
        } else if (msg == "dump")
        {
            llOwnerSay("Limb #" + (string)llList2Integer(my_limbs, 0));
            llOwnerSay(llList2CSV(animrot));
            llOwnerSay(llList2CSV(animpos));
        } else if ((msg == "aninit") && (llListFindList(my_limbs, [num]) >= 0))
        {
            list temp = llParseString2List((string)id, ["!"], []);
            list tpos;
            list trot;
            rotation ro;
            integer n;
            integer l = llGetListLength(temp);

            if (animrot == [])
            {
                animrot = [llGetLocalRot()];
                animpos = [llGetLocalPos()];
                joint = (vector)llList2String(temp, 0);
                offset = llGetLocalPos() - joint;

                for (n=1; n<l; ++n)
                {
                    if (use_euler) {
                        ro = llEuler2Rot(DEG_TO_RAD * (vector)llList2String(temp, n));
                    } else {
                        ro = (rotation)llList2String(temp, n);
                    }
                    animrot += [llGetLocalRot() * ro];
                    animpos += [offset * ro + joint];
                }
            } else {
                trot = [llGetLocalRot()];
                tpos = [llGetLocalPos()];
                joint = (vector)llList2String(temp, 0);

                for (n=1; n<l; ++n)
                {
                    if (use_euler) {
                        ro = llEuler2Rot(DEG_TO_RAD * (vector)llList2String(temp, n));
                    } else {
                        ro = (rotation)llList2String(temp, n);
                    }
                    offset = llList2Vector(animpos, n) - joint;
                    trot += [llList2Rot(animrot, n) * ro];
                    tpos += [offset * ro + joint];
                }
                animrot = trot;
                trot = [];
                animpos = tpos;
                tpos = [];
            }
        } else if (msg == "euler") use_euler = num;
    }
    
    listen(integer chan, string name, key id, string mesg)
    {
        integer step = (integer)mesg;
        llSetPrimitiveParams([PRIM_POSITION, llList2Vector(animpos, step), PRIM_ROTATION, llList2Rot(animrot, step) / llGetRootRotation()]);
    }
}