//////////////////////////////////////////////////////////
//                 PUPPETEER ANIMATOR                   //
//////////////////////////////////////////////////////////
// Gremlin: Puppeteer Animator, see Puppeteer Recorder
//////////////////////////////////////////////////////////
//   (C) Wizardry and Steamworks 2011, license: GPLv3   //
// Please see: http://www.gnu.org/licenses/gpl.html     //
// for legal details, rights of fair usage and          //
// the disclaimer and warranty conditions.              //
//////////////////////////////////////////////////////////
 
string pupData;
key pQuery;
 
integer nDone = 0;
list pos = [];
list rot = [];
 
default
{
    state_entry() {
        nDone = llGetInventoryNumber(INVENTORY_NOTECARD)-1;
        do {
            if(llGetInventoryName(INVENTORY_NOTECARD, nDone) == "Puppet")
                jump found_puppet;
        } while(--nDone>0);
        return;
@found_puppet;
        pQuery = llGetNotecardLine("Puppet", nDone);
        llSetTimerEvent(1);
    }
    on_rez(integer num) {
        llResetScript();
    }
 
    dataserver(key query_id,string data) {
        if (query_id != pQuery) return;
        if (data == EOF) {
            nDone = -1;
            return;
        }
        if(data == "") jump next;
        pupData += data;
@next;
        pQuery = llGetNotecardLine("Puppet", ++nDone);
    }
    timer() {
        if(~nDone) return;
        llSetTimerEvent(0);
        list tPup = llParseString2List(pupData, ["[K]"], [""]);
        pos = llDeleteSubList(llParseString2List(llList2String(tPup, 0), ["#"], [""]), 0, 0);
        rot = llDeleteSubList(llParseString2List(llList2String(tPup, 1), ["#"], [""]), 0, 0);
        pupData = "";
        state puppet;
    }
}
 
state puppet {
    state_entry() {
        llSetTimerEvent(1.0);
    }
    touch_start(integer num) {
        if(nDone = ~nDone ) {
            llSetTimerEvent(1.0);
            return;
        }
        llSetTimerEvent(0);
    }
    timer() {
 
        list tPos = llParseString2List(llList2String(pos, 0), ["<", ",", ">"], [""]);
        pos += llList2String(pos, 0);
        pos = llDeleteSubList(pos, 0, 0);
        vector sPos = <llList2Float(tPos, 0), llList2Float(tPos, 1), llList2Float(tPos, 2)>;
 
        list tRot = llParseString2List(llList2String(rot, 0), ["<", ",", ">"], [""]);
        rot += llList2String(rot, 0);
        rot = llDeleteSubList(rot, 0, 0);
        rotation sRot = <llList2Float(tRot, 0), llList2Float(tRot, 1), llList2Float(tRot, 2), llList2Float(tRot, 3)>;
 
        llSetPos(sPos);
        llSetLocalRot(sRot);
    }
}