// Colour of the prim when the light is ON:
vector vColOn = <1.00, 0.75, 0.50>;
//               ^^^^  ^^^^  ^^^^^
//               Red  Green  Blue

// Colour of the prim when the light is OFF:
vector vColOff = <1.00, 1.00, 1.00>;
//                ^^^^  ^^^^  ^^^^^
//                Red  Green  Blue

////////////////////////////////////////////
// DO NOT CHANGE THE CODE BELOW THIS LINE //
////////////////////////////////////////////

integer bOn = FALSE;
vector vSun;

default
{
    state_entry()
    {
        llSetPrimitiveParams([PRIM_COLOR, ALL_SIDES, vColOff, 1, PRIM_FULLBRIGHT, ALL_SIDES, FALSE, PRIM_GLOW, ALL_SIDES, 0]);
        llSetTimerEvent(5.0);
    }
    
    timer()
    {
        vSun = llGetSunDirection();
        if (vSun.z < 0 && !bOn)
        {
            bOn = TRUE;
            llSetPrimitiveParams([PRIM_POINT_LIGHT, TRUE, <1, 1, 1>, 1.0, 10.0, 0.75]);
            llSetPrimitiveParams([PRIM_COLOR, ALL_SIDES, vColOn, 1, PRIM_FULLBRIGHT, ALL_SIDES, TRUE, PRIM_GLOW, ALL_SIDES, 0.15]);
        }
        else if (vSun.z >= 0 && bOn)
        {
            bOn = FALSE;
            llSetPrimitiveParams([PRIM_POINT_LIGHT, FALSE, <1, 1, 1>, 1.0, 10.0, 0.75]);
            llSetPrimitiveParams([PRIM_COLOR, ALL_SIDES, vColOff, 1, PRIM_FULLBRIGHT, ALL_SIDES, FALSE, PRIM_GLOW, ALL_SIDES, 0]);
        }
    }
}