// saves an oar with chat command
//
// YOU MUST enable osConsoleCommand in your [XEngine] section!
//
// i.e. Allow_osConsoleCommand = 00000000-0000-0000-0000-000000000000
// replace the zeros with your uuid
// set "oarpath" below if you want to use a location other than the current directory
integer listenHandle;
integer cmdchan = 99;
string oarpath = "./";
default
{
    state_entry()
    {
        //  Registers the listen to the current owner of the object at the moment of the call
        listenHandle = llListen(cmdchan, "", llGetOwner(), "");
    }
 
    listen(integer channel, string name, key id, string message)
    {
        if(message == "save")  //got save, make an oar
        {
            //we filtered to only listen to the current owner in the llListen call above!
            string region = llGetRegionName();
            llSay(0,"Saving OAR for current region to " + oarpath + region + ".oar");
            osConsoleCommand("change region \"" + region + "\"");
            osConsoleCommand("save oar \"" + oarpath + region + ".oar\"");
            llSay(0,"please wait...");
            llSleep(10.0);
            llSay(0,"Done");
        }
        else if(message != "save")  //bad input, tell the user how
        {
            llSay(0,"Usage: /" + cmdchan + " save");
        }
    }
 
    on_rez(integer start_param)// triggered when rezzed from agent's or prim's inventory
    {
        llResetScript();// by resetting on rez, the script registers a new listen handle
    }
 
    // Registering a new listen handle with the new owner by script reset
    changed(integer change)// triggered by various events that change the task
    {
        if (change & CHANGED_OWNER)// when a new owner is detected
        {
            llResetScript();
        }
    }
}