
// SUPER-SIMPLE NPC POSEBALL SCRIPT
// by Aine Caolmhe Feb 2013
// You are completely free to edit and alter this however you like
//
// Place this in a prim along with the animation you want the NPC to play.
// If you have a specific appearance you want the NPC to use, add that notecard too
// or wear it the first time you touch the prim and your appearance will be cloned and saved
//
// On touch, user's appearance is cloned to a notecard if no appearance is stored
// NPC is rezzed and "sits" on  the rezzing object and plays the animation in inventory.
// Touching the prim again will kill the NPC
//
// The following OSSL functions must be enabled in the region (OpenSim.ini)
//
// [NPC] section -- to allow creation of NPCs
//
// Enabled = true
//
// [XEngine] section to enable the functions we need to use
//
// Allow_osAgentSaveAppearance = true
// Allow_osNpcCreate = true
// Allow_osNpcRemove = true
// Allow_osNpcSit = true
// Allow_osNpcPlayAnimation = true
// Allow_osNpcStopAnimation = true
// 
// Lots of comments included in this script since it was written to help someone learn the basics...
// 
key npc=NULL_KEY;
string notecardName="steph stlouis";          // if no notecard in inventory, toucher's appearance will be cloned to this cardname and used
string npcFirstName="steph";                      // change to whatever you like
string npcLastName="stlouis";                     // ditto
vector sitTargetPos= <0.0,0.0,1.75>;            // set sit target as per any poseball (Magic Sit Kit makes it easy)
rotation sitTargetRot= ZERO_ROTATION;           // or whatever you like
string animToPlay;                              // will use the 1st one if finds in inventory if blank, or the "built in" dance1 if none is found
string hovertext="Click to rez steph stlouis";

default
{
    state_entry()
    {
        llSetText(hovertext, <1,1,1>, 1);
        if (sitTargetPos==ZERO_VECTOR) sitTargetPos=<0,0,0.00001> ;     // sit target cannot be zero vector
    }
    touch_start(integer num)
    {
        // if an NPC is already active, touching the prim kills it and stops
        //if( llDetectedKey(0) != llGetOwner() ) return;
        if (npc!=NULL_KEY)
        {
            llSetText(hovertext, <1,1,1>, 1);
            osNpcRemove(npc);
            npc=NULL_KEY;
            return;
        }
        // Otherwise the touch gets things started...
        // first, check whether we have a notecard in inventory to use for our NPC. If none is found, clone and store the toucher's appearance, else use the first one
        if (!llGetInventoryNumber(INVENTORY_NOTECARD))
        {
            osAgentSaveAppearance(llDetectedKey(0),notecardName);
        }
        else notecardName=llGetInventoryName(INVENTORY_NOTECARD,0);
        
        // next, if an animation has been specified make sure it's in inventory - otherwise see if we can find one to play or use fallback of dance
        if ((animToPlay=="") || (llStringLength(animToPlay)>0 && llGetInventoryType(animToPlay)!=INVENTORY_ANIMATION))
        {
            if (!llGetInventoryNumber(INVENTORY_ANIMATION)) animToPlay="dance1";
            else animToPlay=llGetInventoryName(INVENTORY_ANIMATION,0);
        }
        
        // now all we have to do is rez the NPC and have it sit on this prim which will trigger the changed event
        llSetText("",<0,0,0>,0);
        npc = osNpcCreate(npcFirstName,npcLastName,llGetPos()+<0.0,0.0,1>,notecardName,OS_NPC_SENSE_AS_AGENT);
        osNpcSit(npc, llGetKey(), OS_NPC_SIT_NOW);
    }
    changed(integer change)
    {
    // Animate our NPC when it sits down
        if (change & CHANGED_LINK)
        {
            osNpcStopAnimation(npc,"Sit");
            osNpcPlayAnimation(npc,animToPlay);
        }
    }
}