float speed = 10.0; // How long it takes to reach target pos.
vector offset = <0.0, 0.0, 2.03>; // The shift in position from home pos.

vector home_pos;
vector new_pos;
float val = 0.0;
float inc = 0.0;

set_home()
{
    home_pos = (vector)llGetObjectDesc();
    new_pos = home_pos + offset;
}

vector cos_int(vector start, vector end, float v)
{
   v = (1.0 - llCos(v * PI)) / 2.0;
   return start * (1.0 - v) + end * v;
}

default
{
    state_entry()
    {
        llSetTimerEvent(0.0);
        llListen(222222222,"","","");
        if(llGetObjectDesc() == "")
            llSetObjectDesc((string)llGetPos());
        set_home();
    } 
    
    listen(integer total_number, string n, key k, string m)
    {
        if(m == "set")
        {
            llSetObjectDesc((string)llGetPos());
            set_home();
        }
        else
        {
            if(m == "up")
                inc = speed;
            if(m == "down")
                inc = -speed;
            if(m == "up" || m == "down")
            {
                llResetTime();
                llTriggerSound("OrganLiftMechanical", 1.0);
                llSetTimerEvent(0.1);
            }
        }
    }
    
    timer()
    {
        val = val + (llGetAndResetTime() / inc);
        if(val > 1.0)
        {
            llSetTimerEvent(0.0);
            val = 1.0;
            //llOwnerSay("upped");
        }
        if(val < 0.0)
        {
            llSetTimerEvent(0.0);
            val = 0.0;
            llSay(222222222,"close");
            //llOwnerSay("downed");
        }
        llSetRegionPos(cos_int(home_pos, new_pos, val));
    }
}
